<!DOCTYPE html>
<html>
   <head>
      <?php $this->load->view('restaurant/includes/includes.php'); ?>
      <?php $this->load->view('restaurant/includes/table-css.php'); ?>
   </head>
   <body>
      <div id="wrapper">
         <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
         <div class="content-page">
            <div class="content">
               <div class="container-fluid">
                  <div class="row">
                     <div class="col-12">
                        <div class="page-title-box">
                           <h4 class="page-title float-left">Restaurant styles</h4>
                           <ol class="breadcrumb float-right">
                              <button type="button" class="btn btn-gradient btn-rounded waves-light waves-effect w-md" data-toggle="modal" data-target="#add-style">Manage styles</button>
                           </ol>
                           <div class="clearfix"></div>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="row">
                  <div class="col-12">
                     <div class="card-box table-responsive">
                        <table id="datatable" class="table table-bordered table-striped my-table">
                           <thead>
                              <tr>
                                 <th width="60%">Styles</th>
                                 <th width="20%">Status</th>
                                 <th width="20%">Delete</th>
                              </tr>
                           </thead>
                           <tbody>
							   <?php foreach($rest_styles as $st){?>
 			                    <tr>
 			                        <td><?=$st->name?></td>
									<td>
										<?php if ($st->status) { ?>
											<span style="color:green;">Active</span>
										<?php }else { ?>
											<span style="color:green;">Deactivated</span>
										<?php } ?>
									</td>
 			                        <td><a href="<?=site_url('restaurant/styles/delete/'.$st->rs_id)?>"><button class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:11px;">Delete</button></a></td>
 			                    </tr>
 			                  <?php };?>
                           </tbody>
                        </table>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <?php $this->load->view('restaurant/includes/footer.php'); ?>
      </div>
      <div class="modal fade" id="add-style" role="dialog">
         <div class="modal-dialog">
            <div class="modal-content">
               <div class="modal-header">
                  <button type="button" class="close" data-dismiss="modal">&times;</button>
                  <h4 class="modal-title">ADD RESTAURANT STYLE</h4>
               </div>
               <div class="modal-body">
                  <form id="add-form" action="<?=site_url('restaurant/styles/addData')?>" method="post">
                     <div class="row">
						 <?php foreach ($styles as $style) { ?>
							 <div class="col-md-6">
 	                           <div class="form-group">
								   <label class="ms-checkbox-wrap ms-checkbox-primary">
 	                                <input type="checkbox" name="styles[]" value="<?=$style->rs_id?>" <?php if($style->status) {?> checked <?php };?>> <i class="ms-checkbox-check"></i>
 	                              </label> <span> <?=$style->name?> </span>
 	                           </div>
 	                        </div>
						 <?php } ?>
                     </div>
               </div>
               <div class="modal-footer">
               <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
               <button type="submit" class="btn btn-success">Add</button>
               </form>
               </div>
            </div>
         </div>
      </div>
   </body>
   <?php $this->load->view('restaurant/includes/scripts.php'); ?>
   <?php $this->load->view('restaurant/includes/table-script.php'); ?>
</html>
