<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('restaurant/includes/includes.php'); ?>
    <?php $this->load->view('restaurant/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">END OF DAY REPORT-  <?=$date?></h4>
                  
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                 <h4 style="padding-top : 10px;padding-bottom:10px;">
                  <span style="float:right;font-style:italic;font-size:14px;">TOTAL AMOUNT: BHD <?php echo number_format( $total,'3');?> </span><br>  
                 </h4>
                 <hr>
                  <table id="endofdayreport-datatable-buttons" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th width="10%">Order No.</th>
                            <th width="15%">Customer Details</th>
                            <!--<th width="15%">Restaurant Name</th>-->
                            <th width="15%">Ordered On</th>
                            <th width="20%">Delivery Address</th>
                            <th width="10%">Price(BHD) </th>
                            <th width="15%">Completed On</th>
                            <th width="20%">Completed By(Driver Details)</th>
                        </tr>
                    </thead>
                    <tbody>
                            <?php foreach($orders as $order) {?>
                              <tr>
                                <td>ORD<?=$order->order_id?></td>
                                <td><?=$order->username?><br>
                                    <?=$order->useremail?><br>
                                    <?=$order->userphone?>
                                </td>
                                <!--<td><?=$order->rest_name?></td>-->
                                <td><?php echo date('d M Y',strtotime($order->ordered_date));?>, <br><?=$order->ordered_time?></td>
                                <td>
                                  <?=$order->area?><br>
                                  <?=$order->block?>, <?=$order->road_no?>, <?=$order->building?>, <?=$order->landmark?>, <?=$order->flat?><br>
                                  Mobile no: +973 <?=$order->mobile?>
                                </td>
                                <td>BHD <?=number_format($order->subtotal,'3')?> </td>
                                <td><?=$order->completed?></td>
                                <td><?=$order->driver?><br><?=$order->vehicle?></td>
                              </tr>
                            <?php };?>
                       
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      
       
      <?php $this->load->view('restaurant/includes/footer.php'); ?>
      
    </div>
  </body>
  <?php $this->load->view('restaurant/includes/scripts.php'); ?>
  <?php $this->load->view('restaurant/includes/table-script.php'); ?>
  <script type="text/javascript">
     $(document).ready(function() {
    var table = $('#endofdayreport-datatable-buttons').DataTable({
           "ordering": false,
           lengthChange: false,
           buttons: 
           [
            'csv',
            {
                extend: 'pdfHtml5',
                title: 'End Of Day Report -  <?=$date?>'
            },
           ]
           });
           table.buttons().container()
                .appendTo('#endofdayreport-datatable-buttons_wrapper .col-md-6:eq(0)');
          });
  </script> 
  
  <script>
      function approve(c_id)
    	{
    		$('#disable_id').val(c_id);
    		$('#approve-order').modal('show');
    	}
    	function reject(c_id)
    	{
    		$('#enable_id').val(c_id);
    		$('#reject-order').modal('show');
    	}
    
  </script>
</html>
