<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('restaurant/includes/includes.php'); ?>
    <?php $this->load->view('restaurant/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">RESTAURANT RATINGS AND REVIEWS</h4>
                 
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                     <thead>
                       <tr>
                           <th width="30%">Restaurant Name</th>
                           <th width="10%">Ratings</th>
                           <th width="20%">Reviews</th>
                           <th width="25%">Customer Details</th>
                           <th width="15%">Date & Time</th>
                       </tr>
                    </thead>
                   <tbody>
                     <?php foreach($ratings as $rating){?>
                       <tr>
                           <td><?=$rating->restaurant?></td>
                           <td><?=$rating->rating;?> ★</td>
                           <td><?=$rating->comments;?></td>
                           <td><?php if($rating->type=='guest') { echo"Guest"; } else {  echo $rating->customer; }?></td>
                           <td><?php echo date('d M Y',strtotime($rating->date)); ?>, <br><?php echo $rating->time; ?></td>
                       </tr>
                     <?php };?>  
                     </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('restaurant/includes/footer.php'); ?>
    </div>
  </body>
  <?php $this->load->view('restaurant/includes/scripts.php'); ?>
  <?php $this->load->view('restaurant/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
</html>
