<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('restaurant/includes/includes.php'); ?>
    <?php $this->load->view('restaurant/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">PROMOTIONS</h4>
                 
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                          <th width="10%">Image</th>
                          <th width="20%">Promotion Code</th>
                          <th width="30%">Promotion Title</th>
                          <th width="25%">Price</th>
                          <th width="15%">Description</th>
                          <th width="5%">Details</th>
                          <th width="5%">Edit</th>
                          <th width="5%">Status</th>
                          <th width="5%">Delete</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach($promotions as $promo) {?>
                        <tr>
                          <td>
                            <?php if($promo->image!='') {?>
                              <img src="<?=base_url().$promo->image;?>" width="100%">
                            <?php } else {?>
                              <img src="<?=base_url()?>uploads/restaurant/promotion/default.svg" width="100%">  
                            <?php };?>
                          </td>    
                          <td><?=$promo->code?></td>    
                          <td><?=$promo->title?></td>
                          <td>BHD <?=number_format($promo->price,'3')?> </td>
                          <td><?=$promo->description?></td>
                          <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="<?= site_url('restaurant/promotions/details/'.$promo->pr_id)?>">View</a></td>
                          <!-- <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="<?= site_url('restaurant/promotions/images/'.$promo->pr_id)?>">Images</a></td> -->
                          <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="<?= site_url('restaurant/promotions/edit/'.$promo->pr_id)?>">Edit</a></td>
                          <td>
                             <?php
                                    if ($promo->status=='active')
                                       {
                                         $status = "Active";
                                         $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$promo->pr_id.')" >Block</a>';
                                       }
                                       elseif($promo->status=='blocked')
                                       {
                                         $status = "Blocked";
                                         $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$promo->pr_id.')">Activate</a>';
                                       }
                                       else
                                       {
                                            $status = "Requested";
                                            $action = '';
                                       }
                                    ?>
                              <?=$status.'<br>'.$action;?>
                          </td>
                          <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="del(<?=$promo->pr_id?>)">Delete</a></td>
                        </tr>
                      <?php };?>  
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      
        <div class="modal fade" id="disable-promo" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DISABLE PROMOTION</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to disable this promotion?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/promotions/disable_promotion')?>" method="post">
                      <input type="hidden" name="promo_id" id="disable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Disable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="enable-promo" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ENABLE PROMOTION</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to enable this promotion?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/promotions/enable_promotion')?>" method="post">
                      <input type="hidden" name="promo_id" id="enable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Enable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="delete-promo" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DELETE PROMOTION</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to delete this promotion?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/promotions/deletePromotion')?>" method="post">
                      <input type="hidden" name="promotion_id" id="promo_del_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Delete</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
      
      <?php $this->load->view('restaurant/includes/footer.php'); ?>
    </div>
  </body>
  <?php $this->load->view('restaurant/includes/scripts.php'); ?>
  <?php $this->load->view('restaurant/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
  <script>
      function disable(c_id)
    	{
    		$('#disable_id').val(c_id);
    		$('#disable-promo').modal('show');
    	}
    	function enable(c_id)
    	{
    		$('#enable_id').val(c_id);
    		$('#enable-promo').modal('show');
    	}
        function del(c_id)
    	{
    		$('#promo_del_id').val(c_id);
    		$('#delete-promo').modal('show');
    	}
  </script>
</html>
