<!DOCTYPE html>
<html>
   <head>
      <?php $this->load->view('restaurant/includes/includes.php'); ?>
      <?php $this->load->view('restaurant/includes/table-css.php'); ?>
   </head>
   <body>
      <div id="wrapper">
         <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
         <div class="content-page">
            <div class="content">
               <div class="container-fluid">
                  <div class="row">
                     <div class="col-12">
                        <div class="page-title-box">
                           <h4 class="page-title float-left">Manage promotion categories</h4>
                           <ol class="breadcrumb float-right">
                              <button type="button" class="btn btn-gradient btn-rounded waves-light waves-effect w-md" data-toggle="modal" data-target="#add-cat">Add category</button>
                           </ol>
                           <div class="clearfix"></div>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="row">
                  <div class="col-12">
                     <div class="card-box table-responsive">
                        <table id="datatable" class="table table-bordered table-striped my-table">
                           <thead>
                              <tr>
                                 <th width="60%">Category Name</th>
                                 <th width="20%">Status</th>
                                 <th width="20%">Edit</th>
                              </tr>
                           </thead>
                           <tbody>
                              <?php $i=1; foreach($categories as $cat){?>
                              <tr>
                                 <td><?=$cat->cat_name?></td>
                                 <?php
                                    if ($cat->status)
                                       {
                                         $status = "Active";
                                         $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$cat->pcat_id.')" >Block</a>';
                                       }
                                       else
                                       {
                                         $status = "Blocked";
                                         $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$cat->pcat_id.')">Activate</a>';
                                       }
                                    ?>
                                 <td><?=$status.'<br>'.$action;?></td>
                                 <td><button class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="edit('<?=$cat->pcat_id?>')">Edit</button></td>
                              </tr>
                              <?php $i++; };?>
                           </tbody>
                        </table>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <?php $this->load->view('restaurant/includes/footer.php'); ?>
      </div>
      <div class="modal fade" id="add-cat" role="dialog">
         <div class="modal-dialog">
            <div class="modal-content">
               <div class="modal-header">
                  <button type="button" class="close" data-dismiss="modal">&times;</button>
                  <h4 class="modal-title">ADD CATEGORY</h4>
               </div>
               <div class="modal-body">
                  <form id="add-form" action="<?=site_url('restaurant/promotions/addCatData')?>" method="post">
                     <div class="row">
                        <div class="col-md-12">
                           <div class="form-group">
                              <label for="select">Name</label>
                              <input type="text" class="form-control" name="name" id="name" required>
                           </div>
                        </div>
                     </div>
               </div>
               <div class="modal-footer">
               <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
               <button type="submit" class="btn btn-success">Add</button>
               </form>
               </div>
            </div>
         </div>
      </div>
      <div class="modal fade" id="edit-cat" role="dialog">
         <div class="modal-dialog">
            <div class="modal-content">
               <div class="modal-header">
                  <button type="button" class="close" data-dismiss="modal">&times;</button>
                  <h4 class="modal-title">EDIT CATEGORY</h4>
               </div>
               <div class="modal-body">
                  <form id="add-form" action="<?=site_url('restaurant/promotions/editData')?>" method="post">
					  <input type="hidden" name="cat_id" id="cat_id">
                     <div class="row">
                        <div class="col-md-12">
                           <div class="form-group">
                              <label for="select">Name</label>
                              <input type="text" class="form-control" name="name" id="st_name" required>
                           </div>
                        </div>
                     </div>
               </div>
               <div class="modal-footer">
               <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
               <button type="submit" class="btn btn-success">Update</button>
               </form>
               </div>
            </div>
         </div>
        </div>
        
         <div class="modal fade" id="disable-branch" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DISABLE CATEGORY</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to disable this catgeory?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/promotions/disableCat')?>" method="post">
                      <input type="hidden" name="cat_id" id="disable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Disable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="enable-branch" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ENABLE CATEGORY</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to enable this catgeory?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/promotions/enableCat')?>" method="post">
                      <input type="hidden" name="cat_id" id="enable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Enable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
         
   </body>
   <?php $this->load->view('restaurant/includes/scripts.php'); ?>
   <?php $this->load->view('restaurant/includes/table-script.php'); ?>
   <script>
      function add()
      {
	     $('#add-cat').modal('show');
      }
      function edit(id)
      {
	     $('#cat_id').val(id);
	     $.ajax({
	        method: "POST",
	        url: "<?=site_url('restaurant/promotions/getCatDetails');?>",
	        data : { id : id },
	        dataType : "json",
	        success : function(data)
	        {
		        $('#st_name').val(data.cat_name);
		        $('#edit-cat').modal('show');
	        }
	     });
      }
   </script>
   <script>
      function disable(c_id)
    	{
    		$('#disable_id').val(c_id);
    		$('#disable-branch').modal('show');
    	}
    	function enable(c_id)
    	{
    		$('#enable_id').val(c_id);
    		$('#enable-branch').modal('show');
    	}
    
  </script>
</html>
