<!DOCTYPE html>
<html>
   <head>
      <?php $this->load->view('restaurant/includes/includes.php'); ?>
      <?php $this->load->view('restaurant/includes/table-css.php'); ?>
   </head>
   <body>
      <div id="wrapper">
         <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
         <div class="content-page">
            <div class="content">
               <div class="container-fluid">
                  <div class="row">
                     <div class="col-12">
                        <div class="page-title-box">
                           <h4 class="page-title float-left">Profile Details</h4>
						   <ol class="breadcrumb float-right">
                              <a href="<?=site_url('restaurant/profile/edit/'.$rest->r_id)?>"><button type="button" class="btn btn-gradient btn-rounded waves-light waves-effect w-md">Edit Profile</button></a>
                           </ol>
						   <div class="clearfix"></div>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="row">
                  <div class="col-md-6">
                     <div class="card-box table-responsive">
						 <table class="table ms-profile-information">
	                       <tbody>
	                         <tr>
	                           <th scope="row">Restaurant Name</th>
	                           <td><?=$rest->rest_name?></td>
	                         </tr>
	                         <tr>
	                           <th scope="row">Restaurant Code</th>
	                           <td><?=$rest->rest_code?></td>
	                         </tr>
	                         <tr>
	                           <th scope="row">Email Address</th>
	                           <td><?=$rest->rest_email?></td>
	                         </tr>
	                         <tr>
	                           <th scope="row">Phone Number</th>
	                           <td><?=$rest->rest_phone?></td>
	                         </tr>
	                         <tr>
	                           <th scope="row">Open Time</th>
	                           <td><?php echo date('h:i A',strtotime($rest->open_time));?></td>
	                         </tr>
	                         <tr>
	                           <th scope="row">Close Time</th>
	                           <td><?php echo date('h:i A',strtotime($rest->close_time));?></td>
	                         </tr>
	                         <tr>
	                           <th scope="row">Location</th>
	                           <td><?=$rest->landmark?></td>
	                         </tr>
	                         <tr>
	                           <th scope="row">Delivery Charge</th>
	                           <td>BHD <?=number_format($rest->delivery_charge,'3')?> </td>
	                         </tr>
	                         <tr>
	                           <th scope="row">Minimum Orders</th>
	                           <td>BHD <?=number_format($rest->min_order,'3')?></td>
	                         </tr>
	                       </tbody>
	                     </table>
	                     <label scope="row"><b>Restaurant Image</b></label>
						 <img src="<?=base_url() . $rest->rest_image?>" width="100%">
						 <br><br>
						 <label scope="row"><b>Thumbnail</b></label>
						 <img src="<?=base_url() . $rest->thumbnail?>" width="100%">
                     </div>
                  </div>
				  <div class="col-md-6">
                     <div class="card-box table-responsive">
						 <h5 class="section-title">Address</h5>
	                     <p>
	                       <?=$rest->address1?><br>
	                     </p>

	                     <div class="ms-profile-skills">
	                       <h5 class="section-title">Cuisines</h5>
	                       <?php if(count($types)==0) {?>
                             <i>No Cuisines</i> <br>
                             <?php } else { ?>
                            <ul class="ms-skill-list">
                             <?php foreach($types as $type) {?>  
                              <li class="ms-skill"><?=$type->name?></li>
                            <?php } };?>
                            </ul>
                           
                           <br>  
                           <label scope="row"><b>Cover Image</b></label>
						   <img src="<?=base_url() . $rest->cover_image?>" width="100%">
	                     </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <?php $this->load->view('restaurant/includes/footer.php'); ?>
      </div>
      <div class="modal fade" id="edit-profile" role="dialog">
         <div class="modal-dialog">
            <div class="modal-content">
               <div class="modal-header">
                  <button type="button" class="close" data-dismiss="modal">&times;</button>
                  <h4 class="modal-title">EDIT PROFILE</h4>
               </div>
               <div class="modal-body">
                  <form action="<?=site_url('restaurant/profile/editData')?>" method="post" id="edit-form" enctype="multipart/form-data">
                     <div class="row">
						 <div class="col-md-12">
							 <div class="form-group">
								 <label for="select">Restaurant Name</label>
	  						   <input type="text" class="form-control" name="name" id="name" required>
	  						   <input type="hidden" name="rest_id" id="restaurant_id">
							</div>
						 </div>
						 <div class="col-md-12">
							 <div class="form-group">
								 <label for="select">Restaurant Code</label>
	  						   <input type="text" class="form-control" name="code" id="code" required>
							</div>
						 </div>
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Phone</label>
	 						   <input type="text" class="form-control" name="phone" id="phone" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" maxlength="9" required>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Email</label>
	 						   <input type="email" class="form-control" name="email" id="email" required>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Open Time</label>
	 						   <input type="time" class="form-control" name="open_time" id="open_time" required>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Close Time</label>
	 						   <input type="time" class="form-control" name="close_time" id="close_time" required>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Latitude</label>
	 						   <input type="text" class="form-control" name="latitude" id="latitude" required>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Longitude</label>
	 						   <input type="text" class="form-control" name="longitude" id="longitude" required>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Address</label>
	 						    <textarea type="text" class="form-control" name="address1" id="address1" required></textarea>
							</div>
						</div>
						
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Location</label>
	 						   <input type="text" class="form-control" name="landmark" id="landmark" required>
							</div>
						</div>
						
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">City</label>
	 						   <input type="text" class="form-control" name="city" id="city" required>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Country</label>
	 						   <input type="text" class="form-control" name="country" id="country" required>
							</div>
						</div>
						<!--<div class="col-md-12">-->
						<!--	<div class="form-group">-->
						<!--		<label for="select">Areacode</label>-->
	 				<!--		   <input type="text" class="form-control" name="pincode" id="pincode" required>-->
						<!--	</div>-->
						<!--</div>-->
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Restaurant Image (422X750 pixels)</label>
	 						   <input type="file" class="form-control" name="image" id="img" onchange="preview_image(this)">
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
							   <img src="<?=base_url() . $rest->rest_image?>" width="100%">
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Cover Image (600X600 Pixels)</label>
	 						   <input type="file" class="form-control" name="cover" id="cover" onchange="preview_image(this)">
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
							   <img src="<?=base_url() . $rest->cover_image?>" width="100%">
							</div>
						</div>
                     </div>
               </div>
               <div class="modal-footer">
               <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
               <button type="submit" class="btn btn-success">Update</button>
               </form>
               </div>
            </div>
         </div>
      </div>
   </body>
   <?php $this->load->view('restaurant/includes/scripts.php'); ?>
   <?php $this->load->view('restaurant/includes/table-script.php'); ?>
   <script type="">
	 function edit(id)
	 {
	   $('#restaurant_id').val(id);
	   $.ajax({
		 method: "POST",
		 url: "<?=site_url('restaurant/profile/getProfileById');?>",
		 data : { id : id },
		 dataType : "json",
		 success : function(data)
		 {
		   $('#name').val(data.rest_name);
		   $('#code').val(data.rest_code);
		   $('#phone').val(data.rest_phone);
		   $('#email').val(data.rest_email);
		   $('#open_time').val(data.open_time);
		   $('#close_time').val(data.close_time);
		   $('#address1').val(data.address1);
		   $('#latitude').val(data.latitude);
		   $('#longitude').val(data.longitude);
		  // $('#pincode').val(data.pincode);
		   $('#country').val(data.country);
		   $('#city').val(data.city);
		   $('#landmark').val(data.landmark);
		   $('#edit-profile').modal('show');
		 }
	   });
	 }

   function preview_image(id)
   {
	 var id = id.id;
	 var x = document.getElementById(id);
	 var size = x.files[0].size;
	 if (size > 5000000)
	 {
	   toastr.error("Please select an image with size less than 5 mb.");
	   document.getElementById(id).value = "";
	 }
	 else
	 {
	   var val = x.files[0].type;
	   var type = val.substr(val.indexOf("/") + 1);
	   s_type = ['jpeg','jpg','png'];
	   var flag = 0;
	   for (var i = 0; i < s_type.length; i++)
	   {
		 if (s_type[i] == type)
		 {
		   flag = flag + 1;
		 }
	   }
	   if (flag == 0)
	   {
		 toastr.error("This file format is not supported.");
		 document.getElementById(id).value = "";
	   }
	   else
	   {
		 var reader = new FileReader();
		 reader.onload = function()
		 {
		   var cn = id.substring(3);
		   var preview = 'preview' + cn;
		   var output = document.getElementById(preview);
		   output.src = reader.result;
		 }
		 reader.readAsDataURL(x.files[0]);
	   }
	 }
   }
   </script>
</html>
