<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('restaurant/includes/includes.php'); ?>
    <?php $this->load->view('restaurant/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">PRODUCTS</h4>
                 
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <div class="col-3">
                      <label for="select">Sort By</label>
                      <select class="form-control" onChange="window.document.location.href=this.options[this.selectedIndex].value;">
                          <option value="">Select</option>
                          <option value="<?=site_url('restaurant/products/index/a')?>">A TO Z</option>
                          <option value="<?=site_url('restaurant/products/index/d')?>">Z TO A</option>
                          <option value="<?=site_url('restaurant/products/index/all')?>">By Created Date</option>
                      </select>  
                  </div>
                  <br>
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                          <th width="10%">Product Image</th>
                          <th width="30%">Product Name</th>
                          <th width="25%">Price</th>
                          <th width="15%">Category</th>
                          <th width="5%">Details</th>
                          <!-- <th width="10%">Images</th> -->
                          <th width="5%">Edit</th>
                          <th width="5%">Status</th>
                          <th width="5%">Delete</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach($products as $pro) {?>
                        <tr>
                          <td><img src="<?=base_url().$pro->thumbnail?>" width="100%"></td>
                          <td><?=$pro->name?></td>
                          <td><?php foreach($pro->prices as $price) { if($price->unit!='') { echo $price->unit; ?> - BHD <?php echo number_format($price->price,'3'); } else { echo 'BHD '.number_format($price->price,'3'); }; ?> <br><?php };?></td>
                          <td><?=$pro->category?></td>
                          <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="<?= site_url('restaurant/products/details/'.$pro->p_id)?>">View</a></td>
                          <!-- <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="<?= site_url('restaurant/products/images/'.$pro->p_id)?>">Images</a></td> -->
                          <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="<?= site_url('restaurant/products/edit/'.$pro->p_id)?>">Edit</a></td>
                          <td>
                             <?php
                                    if ($pro->status=='active')
                                       {
                                         $status = "Active";
                                         $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$pro->p_id.')" >Block</a>';
                                       }
                                       elseif($pro->status=='blocked')
                                       {
                                         $status = "Blocked";
                                         $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$pro->p_id.')">Activate</a>';
                                       }
                                    ?>
                              <?=$status.'<br>'.$action;?>
                          </td>
                          <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="del('<?=$pro->p_id?>')">Delete</a></td>
                        </tr>
                      <?php };?>  
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="disable-product" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DISABLE PRODUCT</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to disable this product?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/products/disable')?>" method="post">
                      <input type="hidden" name="product_id" id="disable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Disable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="enable-product" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ENABLE PRODUCT</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to enable this product?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/products/enable')?>" method="post">
                      <input type="hidden" name="product_id" id="enable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Enable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="delete-product" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DELETE PRODUCT</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to delete this product?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/products/delete')?>" method="post">
                      <input type="hidden" name="product_id" id="delete_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Delete</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
      </div>
      <?php $this->load->view('restaurant/includes/footer.php'); ?>
    </div>
  </body>
  <?php $this->load->view('restaurant/includes/scripts.php'); ?>
  <?php $this->load->view('restaurant/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
  <script>
      function disable(c_id)
    	{
    		$('#disable_id').val(c_id);
    		$('#disable-product').modal('show');
    	}
    	function enable(c_id)
    	{
    		$('#enable_id').val(c_id);
    		$('#enable-product').modal('show');
    	}
        function del(c_id)
    	{
    		$('#delete_id').val(c_id);
    		$('#delete-product').modal('show');
    	}
  </script>
</html>
