<!DOCTYPE html>
<html>
   <head>
      <?php $this->load->view('restaurant/includes/includes.php'); ?>
      <?php $this->load->view('restaurant/includes/table-css.php'); ?>
   </head>
   <body>
      <div id="wrapper">
         <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
         <div class="content-page">
            <div class="content">
               <div class="container-fluid">
                  <div class="row">
                     <div class="col-12">
                        <div class="page-title-box">
                           <h4 class="page-title float-left"><?=$pro->name?></h4>
						   
						   <div class="clearfix"></div>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="row">
                  <div class="col-xl-6 col-md-12">
                  	<div class="ms-panel ms-panel-fh">
                         <div class="ms-panel-body">
		                     <div class="card-box table-responsive">
								 <table class="table ms-profile-information">
				                      <tbody>
				                        <tr>
				                          <th scope="row">Price</th>
				                          <td>
				                          <?php foreach($prices as $price) {?>
				                             <?php if($price->unit!='') { echo $price->unit; ?> &nbsp;- BHD&nbsp;<?php echo number_format($price->price,'3'); } else { echo 'BHD '.number_format($price->price,'3'); };?> <br>
				                          <?php };?> 
				                          </td>
				                        </tr>
				                        <tr>
				                          <th scope="row">Category</th>
				                          <td><?=$menu?></td>
				                        </tr>
				                        <tr>
				                          <th scope="row">Preperation Time(In Minutes)</th>
				                          <td><?=$pro->prep_time?></td>
				                        </tr>
				                        <tr>
				                          <th scope="row">Status</th>
				                          <td><?php if($pro->status=='active') { echo "Active"; } elseif($pro->status=='blocked') { echo "Blocked"; } else { echo "Sold out"; }?></td>
				                        </tr>
				                        <tr>
				                          <th scope="row">Cover Image</th>
				                          <td><img src="<?=base_url().$pro->cover_image?>" width="100%"></td>
				                        </tr>
				                      </tbody>
			                     </table>
		                     </div>
		                   </div>  
                       </div>
                  </div>
				  <div class="col-md-6">
                     <div class="card-box table-responsive">
						 <h5 class="section-title">Description</h2>
	                     <p><?=$pro->description?></p>
	                     <hr>
	                     <?php if(count($categories)>0) { ?>
	                     <div class="ms-profile-skills">
	                      <h5 class="section-title">Product Choices</h2>
	                      <ul class="ms-skill-list">
	                       <?php foreach($categories as $cat) {?>  
	                        <li><b><?=$cat->cat_name?> - <?php if($cat->type=='1') {?> Single Type <?php } else {?> Multiple Type <?php };?></b></li>
	                        <?php foreach($cat->choices as $choice) {?>
	                         <i><?=$choice->name?> <?php if($choice->price!='0') {?>- BHD <?=number_format($choice->price,3)?> <?php };?></i> <br>
	                       <?php } };?> 
	                      </ul>
	                     </div>
	                     <?php };?>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <?php $this->load->view('restaurant/includes/footer.php'); ?>
      </div>
      
   </body>
   <?php $this->load->view('restaurant/includes/scripts.php'); ?>
   <?php $this->load->view('restaurant/includes/table-script.php'); ?>
   <script type="">
   function preview_image(id)
   {
	 var id = id.id;
	 var x = document.getElementById(id);
	 var size = x.files[0].size;
	 if (size > 5000000)
	 {
	   toastr.error("Please select an image with size less than 5 mb.");
	   document.getElementById(id).value = "";
	 }
	 else
	 {
	   var val = x.files[0].type;
	   var type = val.substr(val.indexOf("/") + 1);
	   s_type = ['jpeg','jpg','png'];
	   var flag = 0;
	   for (var i = 0; i < s_type.length; i++)
	   {
		 if (s_type[i] == type)
		 {
		   flag = flag + 1;
		 }
	   }
	   if (flag == 0)
	   {
		 toastr.error("This file format is not supported.");
		 document.getElementById(id).value = "";
	   }
	   else
	   {
		 var reader = new FileReader();
		 reader.onload = function()
		 {
		   var cn = id.substring(3);
		   var preview = 'preview' + cn;
		   var output = document.getElementById(preview);
		   output.src = reader.result;
		 }
		 reader.readAsDataURL(x.files[0]);
	   }
	 }
   }
   </script>
</html>
