<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('restaurant/includes/includes.php'); ?>
    <?php $this->load->view('restaurant/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">Cancelled Orders</h4>
                  
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th width="10%">Order No.</th>
                            <th width="15%">Customer Details</th>
                            <th width="15%">Ordered On</th>
                            <th width="25%">Delivery Address</th>
                            <th width="10%">Price(BHD)</th>
                            <!--<th width="10%">Order Status</th>-->
                            <th width="5%">Details</th>
                            <th width="5%">Cancelled_by</th>
                        </tr>
                    </thead>
                    <tbody>
                            <?php foreach($orders as $order) {?>
                              <tr>
                                <td>ORD<?=$order->order_id?></td>
                                <td><?=$order->username?><br>
                                    <?=$order->useremail?><br>
                                    <?=$order->userphone?>
                                </td>
                                <td><?php echo date('d M Y',strtotime($order->ordered_date));?>, <br><?=$order->ordered_time?></td>
                                <td>
                                  <?=$order->area?><br>
                                  <?=$order->block?>, <?=$order->road_no?>, <?=$order->building?>, <?=$order->landmark?>, <?=$order->flat?><br>
                                  Mobile no: +973 <?=$order->mobile?>
                                </td>
                                <td>BHD <?=number_format($order->total,'3')?></td>
                                <!--<td>Cancelled</td>-->
                                <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:13px;" href="<?=site_url('restaurant/orders/details/'.$order->order_id)?>" >View</a></td>
                                <td><?php if($order->cancelled_by=='restaurant') {?>
                                     Restaurant
                                    <?php } elseif($order->cancelled_by=='branch') {?> 
                                    Branch
                                    <?php } elseif($order->cancelled_by=='customer') {?>
                                    Customer
                                    <?php } else {?>
                                    Admin
                                    <?php };?>
                                </td>
                              </tr>
                            <?php };?>
                       
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('restaurant/includes/footer.php'); ?>
      
    </div>
  </body>
  <?php $this->load->view('restaurant/includes/scripts.php'); ?>
  <?php $this->load->view('restaurant/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
  
</html>
