<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('restaurant/includes/includes.php'); ?>
    <?php $this->load->view('restaurant/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">Approved Orders</h4>
                  
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="user_data" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th width="10%">Order No.</th>
                            <th width="15%">Customer Details</th>
                            <th width="15%">Ordered On</th>
                            <th width="25%">Delivery Address</th>
                            <th width="10%">Price(BHD)</th>
                            <!--<th width="10%">Order Status</th>-->
                            <th width="10%">Assign Driver</th>
                            <th width="5%">Details</th>
                        </tr>
                    </thead>

                  </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('restaurant/includes/footer.php'); ?>
      
     <div class="modal fade" id="add-driver" tabindex="-1" role="dialog" aria-labelledby="modal-5">
        <div class="modal-dialog modal-dialog-centered" role="document">
          <div class="modal-content">
            <div class="modal-header bg-primary">
              <h4 class="modal-title has-icon text-white">ADD DRIVER</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
              <form class="form-horizontal" action="<?=site_url('restaurant/orders/assignDriver')?>" method="post" id="add-form" enctype="multipart/form-data">
                 <div class="form-group m-b-25">
                     <div class="col-12">
                         <label for="select">Drivers<span style="color: red; ">*</span></label>
                         <input type="hidden" name="order_id" id="order_id">
                         <select class="form-control" name="driver_id" required>
                             <option value="">---Select Driver---</option>
                             <?php foreach($drivers as $driver) {?>
                               <option value="<?=$driver->dr_id?>"><?=$driver->name?> - <?=$driver->phone?></option>
                             <?php };?>
                         </select>
                     </div>
                 </div>
               </div>
               <div class="modal-footer">
                 <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                 <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit" id="submit-button">Add</button>
               </div>
              </form>
          </div>
        </div>
      </div>
      
    </div>
  </body>
  <?php $this->load->view('restaurant/includes/scripts.php'); ?>
  <?php $this->load->view('restaurant/includes/table-script.php'); ?>
  
  <script type="text/javascript">
    $(document).ready(function(){
      var dataTable = $('#user_data').DataTable({
        "processing":true,
        "serverSide":true,
        "order":[],
        "ajax":{
          url:"<?=site_url('restaurant/orders/get_approved')?>",
          type:"POST"
        },
        "columnDefs":[
          {
            "target":[0,3,4],
            "orderable":true
          }
        ]
      });
    });
  </script>
   <script type="">
     function add(id)
      {
        $('#order_id').val(id);
        $('#add-driver').modal('show');
      }
    </script>  
</html>
