<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('restaurant/includes/includes.php'); ?>
    <?php $this->load->view('restaurant/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">Promotions</h4>
                  <ol class="breadcrumb float-right">
                    <button type="button" class="btn btn-gradient btn-rounded waves-light waves-effect w-md" onclick="add()">Add Promotion</button>
                  </ol>
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                          <th width="10%">Image</th>
                          <th width="20%">Title</th>
                          <th width="40%">Description</th>
                          <th width="20%">Price</th>
                          <th width="5%">Status</th>
                          <th width="5%">Edit</th>
                      </tr>
                   </thead>
                  <tbody>
                    <?php foreach($promotions as $pro){?>
                      <tr>
                      
                          <td>
                            <?php if($pro->image!='') {?>
                              <img src="<?=base_url().$pro->image;?>" width="100%">
                            <?php } else {?>
                              <img src="<?=base_url()?>uploads/restaurant/promotion/default.svg" width="100%">  
                            <?php };?>
                          </td>
                          <td><?=$pro->title?></td>
                          <td><?=$pro->description?></td>
                          <td>BHD <?=number_format($pro->price,'3')?> </td>
                          <td>
                              <?php if ($pro->status=='active') 
                                  {
                                    $status = "Active";
                                    $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="' . site_url('restaurant/offers/disable_promotion/'.$pro->pr_id) . '" >Disable</a>';
                                  }
                                  elseif($pro->status=='blocked') 
                                  {
                                    $status = "Blocked";
                                    $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="' . site_url('restaurant/offers/enable_promotion/'.$pro->pr_id) . '" >Enable</a>';
                                  }
                                  else
                                  {
                                    $status = "Requested";
                                    $action = '';
                                  }
                                  echo $status.'<br>'.$action;
                              ?>
                          </td>
                          <td><button class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:13px;" onclick="edit('<?=$pro->pr_id?>')">Edit</button></td>
                      </tr>
                    <?php };?>  
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('restaurant/includes/footer.php'); ?>
      
      <div class="modal fade" id="add-style" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ADD PROMOTION</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
              <div class="modal-body">
                <form class="form-horizontal" action="<?=site_url('restaurant/offers/addPromotion')?>" method="post" id="add-form" enctype="multipart/form-data">
                      <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">Title<span style="color: red;">*</span></label>
                             <input type="text" class="form-control" name="title" id="c_title" placeholder="Title" required>
                         </div>
                      </div>
                      <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">Description<span style="color: red;">*</span></label>
                             <textarea type="text" class="form-control" name="description" id="c_description" placeholder="Description" ></textarea>
                         </div>
                      </div>    
                      <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">Price<span style="color: red;">*</span></label>
                               <input type="number" step="any" min="0" class="form-control" name="price"  placeholder="Price" required>
                           </div>
                       </div>
                       <div class="form-group m-b-25">
                           <div class="col-md-12">
                              <label for="select">Image</label>
                               <input type="file" class="form-control" name="image" id="img" onchange="preview_image(this)">
                          </div>
                       </div>
                       
                    </div>
                    <div class="modal-footer">
                      <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                      <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit-button">Add</button>
                    </div>
                </form>
            </div>
          </div>
        </div>

       <div class="modal fade" id="edit-style" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">EDIT PROMOTION</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
              <div class="modal-body">
                <form class="form-horizontal" action="<?=site_url('restaurant/offers/editPromotion')?>" method="post" id="edit-form" enctype="multipart/form-data">
                     
                      <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">Title<span style="color: red;">*</span></label>
                             <input type="text" class="form-control" name="title" id="p_title" placeholder="Title" required>
                             <input type="hidden" name="promotion_id" id="promotion_id">
                         </div>
                      </div>
                      <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">Description<span style="color: red;">*</span></label>
                             <textarea type="text" class="form-control" name="description" id="p_description" placeholder="Description" ></textarea>
                         </div>
                      </div>    
                      <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">Price<span style="color: red;">*</span></label>
                               <input type="number" step="any" min="0" class="form-control" name="price" id="price" placeholder="Price" required>
                           </div>
                       </div>
                       <div class="form-group m-b-25">
                           <div class="col-md-12">
                              <label for="select">Image</label>
                               <input type="file" class="form-control" name="image" id="img" onchange="preview_image(this)">
                          </div>
                       </div>
                       
                    </div>
                    <div class="modal-footer">
                      <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                      <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Update</button>
                    </div>
                </form>
            </div>
          </div>
        </div>

    </div>
  </body>
  <?php $this->load->view('restaurant/includes/scripts.php'); ?>
  <?php $this->load->view('restaurant/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
  <script type="">
     function add()
      {
        $('#add-style').modal('show');
      }

      function edit(id)
      {
        $('#promotion_id').val(id);
        // alert(id);
        $.ajax({
          method: "POST",
          url: "<?=site_url('restaurant/offers/getPromotionDetails');?>",
          data : { id : id },
          dataType : "json",
          success : function(data)
          {
           
            $('#p_title').val(data.title);
            $('#p_description').val(data.description);
            $('#price').val(data.price);
            $('#edit-style').modal('show');
          }
        });
      }
  </script>
  
  <script type="">
   
   function preview_image(id)
   {
     var id = id.id;
     var x = document.getElementById(id);
     var size = x.files[0].size;
     if (size > 5000000)
     {
       toastr.error("Please select an image with size less than 5 mb.");
       document.getElementById(id).value = "";
     }
     else
     {
       var val = x.files[0].type;
       var type = val.substr(val.indexOf("/") + 1);
       s_type = ['jpeg','jpg','png'];
       var flag = 0;
       for (var i = 0; i < s_type.length; i++)
       {
       if (s_type[i] == type)
       {
         flag = flag + 1;
       }
       }
       if (flag == 0)
       {
       toastr.error("This file format is not supported.");
       document.getElementById(id).value = "";
       }
       else
       {
       var reader = new FileReader();
       reader.onload = function()
       {
         var cn = id.substring(3);
         var preview = 'preview' + cn;
         var output = document.getElementById(preview);
         output.src = reader.result;
       }
       reader.readAsDataURL(x.files[0]);
       }
     }
   }
  </script>
</html>
