<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('restaurant/includes/includes.php'); ?>
    <?php $this->load->view('restaurant/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">OFFERS</h4>
                  <ol class="breadcrumb float-right">
                    <button type="button" class="btn btn-gradient btn-rounded waves-light waves-effect w-md" onclick="add()">Add Offer</button>
                  </ol>
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                          <th width="10%">Offer Code</th>
                          <th width="15%">Product Name</th>
                          <th width="10%">Offer Percentage</th>
                          <th width="15%">Start Date</th>
                          <th width="15%">End Date</th>
                          <th width="5%">Status</th>
                          <th width="5%">Edit</th>
                      </tr>
                   </thead>
                  <tbody>
                    <?php foreach($offers as $off){?>
                      <tr>
                          <?php 
                           if ($off->status) 
                              {
                                $status = "Active";
                                // $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="' . site_url('restaurant/offers/disable_offer/'.$off->offer_id) . '" >Disable</a>';
                                $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$off->offer_id.')" >Inactive</a>';
                                  
                              }
                              else 
                              {
                                $status = "Blocked";
                                // $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="' . site_url('restaurant/offers/enable_offer/'.$off->offer_id) . '" >Active</a>';
                                $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$off->offer_id.')" >Active</a>';
                              }
                          ?>
                          <td><?=$off->offer_code?></td>
                          <td><?=$off->product?></td>
                          <td><?=$off->percentage?> %</td>
                          <td><?php echo date('d M Y',strtotime($off->start_date));?>  <?php if($off->start_time != '00:00:00') { echo date('h:i A', strtotime('$off->start_time')); } ?> </td>
                          <td> <?php echo date('d M Y',strtotime($off->end_date));?>  <?php if($off->end_time != '00:00:00') { echo date('h:i A', strtotime('$off->end_time')); } ?></td>
                          <td><?=$status.'<br>'.$action;?></td>
                          <td><button class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="edit('<?=$off->offer_id?>')">Edit</button></td>
                      </tr>
                    <?php };?>  
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('restaurant/includes/footer.php'); ?>
      
      <div class="modal fade" id="add-style" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ADD OFFER</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
              <div class="modal-body">
                <form class="form-horizontal" action="<?=site_url('restaurant/offers/addOffer')?>" method="post" id="add-form">
                     <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">Products<span style="color: red;">*</span></label>
                             <select class="form-control" name="product_id" id="product_id" required="">
                                <option value="">---Select Product---</option>
                               <?php foreach($products as $pro) {?>
                                <option value="<?=$pro->p_id?>"><?=$pro->name?></option>
                               <?php };?>
                             </select>
                         </div>
                      </div>
                      <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">Offer Code<span style="color: red;">*</span></label>
                               <input type="text" class="form-control" name="code" id="code" placeholder="Offer Code" required>
                           </div>
                       </div>
                       <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">Offer Percentage<span style="color: red;">*</span></label>
                               <input type="number" step="any" min="0" class="form-control" name="percentage" placeholder="Percentage" required>
                           </div>
                       </div>
                       <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">Start Date<span style="color: red;">*</span></label>
                               <input type="date" class="form-control" name="start_date" id="start" value="<?=date('Y-m-d')?>" required>
                           </div>
                       </div>

                      <!--<div class="form-group m-b-25">-->
                      <!--     <div class="col-12">-->
                      <!--         <label for="select">Start time</label>-->
                      <!--         <input type="time" class="form-control" name="start_time" id="start_time">-->
                      <!--     </div>-->
                      <!-- </div>-->

                       <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">End Date<span style="color: red;">*</span></label>
                               <input type="date" class="form-control" name="end_date" id="end" value="<?=date('Y-m-d')?>" required>
                           </div>
                       </div>
                      
                       <!--<div class="form-group m-b-25">-->
                       <!--    <div class="col-12">-->
                       <!--        <label for="select">End time</label>-->
                       <!--        <input type="time" class="form-control" name="end_time" id="end_time" >-->
                       <!--    </div>-->
                       <!--</div>-->
                    </div>
                    <div class="modal-footer">
                      <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                      <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit" id="submit-button">Add</button>
                    </div>
                </form>
            </div>
          </div>
        </div>

    <div class="modal fade" id="edit-style" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">EDIT OFFER</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
              <div class="modal-body">
                <form class="form-horizontal" action="<?=site_url('restaurant/offers/editOffer')?>" method="post" id="edit-form">
                      <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">Product<span style="color: red;">*</span></label>
                             <select class="form-control"  name="product_id" id="product" required>                         
                             </select>
                             <input type="hidden" name="offer_id" id="offer_id">
                         </div>
                      </div>
                      <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">Offer Code<span style="color: red;">*</span></label>
                               <input type="text" class="form-control" name="code" id="code_edit" placeholder="Offer Code" required>
                           </div>
                       </div>
                       <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">Offer Percentage<span style="color: red;">*</span></label>
                               <input type="number" step="any" min="0" class="form-control" name="percentage" id="percentage" placeholder="Percentage" required>
                           </div>
                       </div>
                       <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">Start Date<span style="color: red;">*</span></label>
                               <input type="date" class="form-control" name="start_date" id="c_start" value="<?=date('Y-m-d')?>" required>
                           </div>
                       </div>

                      <!--<div class="form-group m-b-25">-->
                      <!--     <div class="col-12">-->
                      <!--         <label for="select">Start time</label>-->
                      <!--         <input type="time" class="form-control" name="start_time" id="c_start_time">-->
                      <!--     </div>-->
                      <!-- </div>-->

                       <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">End Date<span style="color: red;">*</span></label>
                               <input type="date" class="form-control" name="end_date" id="c_end" value="<?=date('Y-m-d')?>" required>
                           </div>
                       </div>
                      
                       <!--<div class="form-group m-b-25">-->
                       <!--    <div class="col-12">-->
                       <!--        <label for="select">End time</label>-->
                       <!--        <input type="time" class="form-control" name="end_time" id="c_end_time" >-->
                       <!--    </div>-->
                       <!--</div>-->
                    </div>
                    <div class="modal-footer">
                      <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                      <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Update</button>
                    </div>
                </form>
            </div>
          </div>
        </div>
        
         <div class="modal fade" id="disable-offer" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DISABLE OFFER</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to disable this offer?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/offers/disable_offer')?>" method="post">
                      <input type="hidden" name="offer_id" id="offer_disable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Disable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="enable-offer" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ENABLE OFFER</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to enable this offer?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/offers/enable_offer')?>" method="post">
                      <input type="hidden" name="offer_id" id="offer_enable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Enable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>

    </div>
  </body>
  <?php $this->load->view('restaurant/includes/scripts.php'); ?>
  <?php $this->load->view('restaurant/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
  <script>
      function disable(offer_id)
    	{
    		$('#offer_disable_id').val(offer_id);
    		$('#disable-offer').modal('show');
    	}
    	function enable(offer_id)
    	{
    		$('#offer_enable_id').val(offer_id);
    		$('#enable-offer').modal('show');
    	}
  </script>
  <script type="">
     function add()
      {
        $('#add-style').modal('show');
      }

      function edit(id)
      {
        $('#offer_id').val(id);
        // alert(id);
        $.ajax({
          method: "POST",
          url: "<?=site_url('restaurant/offers/getOfferDetails');?>",
          data : { id : id },
          dataType : "json",
          success : function(data)
          {
            var offer     = data.offer;
            var product   = data.products;
            // alert(restaurant);
            $('#code_edit').val(offer.offer_code);
            $('#percentage').val(offer.percentage);
            $('#c_start').val(offer.start_date);
            $('#c_end').val(offer.end_date);
            // $('#c_start_time').val(offer.start_time);
            // $('#c_end_time').val(offer.end_time);
            $('#product').html(product);
            $('#edit-style').modal('show');
          }
        });
      }
  </script>
  <script type="">
      $('#add-form').on('submit', function(e){
      e.preventDefault();
    
      var product_id = $('#product_id').val();  
      var code       = $('#code').val();  
      var start      = $('#start').val();
      var end        = $('#end').val();
      var today      = new Date().toISOString().split('T')[0]; 

      if(start < today)
      {
          toastr.error("","Start date cannot be lesser than current date"); 
      }
      else if (start > end)
      {
          toastr.error("","End date cannot be lesser than start date"); 
      }
      else 
      {   
          $.ajax({
              method: "POST",
              url: "<?php echo site_url('restaurant/offers/checkOffer');?>",
              dataType : "json",
              data : { 
                       product_id      : product_id,
                       start_date      : start,
                       end_date        : end,
                       code            : code
                     },
              success : function( data )
              {
                if (data == 0) 
                {
                  document.getElementById("add-form").submit();
                  return true;
                }
                else if (data == 2) 
                {
                  toastr.error("","Offer Code already exists");   
                }
                else if(data == 1)
                {
                  toastr.error("","Offer already exists");         
                }           
              }             
            });           
      }
    });
  </script>
   <script type="">
    $('#edit-form').on('submit', function(e){
      e.preventDefault();
    
      var start  = $('#c_start').val();
      var end    = $('#c_end').val();
      var today  = new Date().toISOString().split('T')[0]; 
     
      if(start < today)
      {
          toastr.error("","Start date cannot be lesser than current date"); 
      }
      else if (start > end)
      {
          toastr.error("","End date cannot be lesser than start date"); 
      }
      else 
      {   
          document.getElementById("edit-form").submit();
          return true;
      }
    });

  </script>
</html>
