<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('restaurant/includes/includes.php'); ?>
    <?php $this->load->view('restaurant/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">COUPONS</h4>
                 
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                          <th width="10%">Coupon  Code</th>
                          <th width="15%">Coupon  Title</th>
                          <th width="15%">Restaurant Name</th>
                          <th width="10%">Offer Percentage</th>
                          <th width="15%">Minimum Cart Value</th>
                          <th width="15%">Start Date</th>
                          <th width="15%">End Date</th>
                          <th width="5%">Status</th>
                      </tr>
                   </thead>
                   <tbody>
                    <?php foreach($coupons as $coup){?>
                      <tr>
                          <?php 
                           if ($coup->status) 
                              {
                                $status = "Active";
                                
                              }
                              else 
                              {
                                $status = "Blocked";
                                
                              }
                          ?>
                          <td><?=$coup->offer_code?></td>
                          <td><?=$coup->title?></td>
                          <td><?=$coup->restaurant?></td>
                          <td><?=$coup->percentage?> %</td>
                          <td>BHD <?=number_format($coup->max_value,'3')?> </td>
                          <td><?php echo date('d M Y',strtotime($coup->start_date));?><?php if($coup->start_time != '00:00:00') { echo ', <br>'.date('h:i A',strtotime($coup->start_time)); } ?> </td>
                          <td> <?php echo date('d M Y',strtotime($coup->end_date));?><?php if($coup->end_time != '00:00:00') { echo ', <br>'.date('h:i A',strtotime($coup->end_time)); } ?></td>
                          <td><?=$status;?></td>
                      </tr>
                    <?php };?>  
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('restaurant/includes/footer.php'); ?>
    </div>
  </body>
  <?php $this->load->view('restaurant/includes/scripts.php'); ?>
  <?php $this->load->view('restaurant/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
</html>
