<!DOCTYPE html>
<html lang="en">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Manage Restaurants Styles | Sigofood</title>
  <?php $this->load->view('restaurant/includes/includes');?>
</head>
<body class="ms-body ms-aside-left-open ms-primary-theme ms-has-quickbar">
 <?php $this->load->view('restaurant/includes/sidebar');?>
  <!-- Main Content -->
  <main class="body-content">
    <?php $this->load->view('restaurant/includes/navbar');?>
        <!-- Body Content Wrapper -->
    <div class="ms-content-wrapper">
      <div class="row">
        <div class="col-md-12">
          <div class="ms-panel">
            <div class="ms-panel-header">
              <button type="button" class="btn btn-danger float-right" onclick="add()">Add Category</button> <br>
              <h6>Category</h6>
               
            </div>
            <div class="ms-panel-body">
              <div class="table-responsive">
                <table id="manage-restaurants" class="table w-100 thead-primary">
                  <thead>
                    <tr>
                        <th></th>
                        <th width="60%">Name</th>
                        <th width="20%">Status</th>
                        <th width="20%">Edit</th>
                    </tr>
                 </thead>
                <tbody>
                  <?php foreach($menu as $me){?>
                    <tr>
                        <td></td>
                        <?php 
                         if ($me->status) 
                            {
                              $status = "Active";
                              $action = '<a class="btn btn-danger" style="font-size:12px;" href="' . site_url('restaurant/menu/disable/'.$me->menu_id) . '" >Disable</a>';
                            }
                            else 
                            {
                              $status = "Blocked";
                              $action = '<a class="btn btn-success" style="font-size:12px;" href="' . site_url('restaurant/menu/enable/'.$me->menu_id) . '" >Enable</a>';
                            }
                        ?>
                        <td><?=$me->name?></td>
                        <td><?=$status.'<br>'.$action;?></td>
                        <td><button class="btn btn-danger" onclick="edit('<?=$me->menu_id?>')">Edit</button></td>
                    </tr>
                  <?php };?>  
                  </tbody>
                </table>
              </div>

            <div class="modal fade" id="add-style" tabindex="-1" role="dialog" aria-labelledby="modal-5">
                <div class="modal-dialog modal-dialog-centered" role="document">
                  <div class="modal-content">
                    <div class="modal-header bg-primary">
                      <h4 class="modal-title has-icon text-white">ADD CATEGORY</h4>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>
                    <div class="modal-body">
                      <form class="form-horizontal" action="<?=site_url('restaurant/menu/addData')?>" method="post" id="add-form">
                         <div class="form-group m-b-25">
                             <div class="col-12">
                                 <label for="select">Name</label>
                                 <input type="text" class="form-control" name="name" id="name" required>
                             </div>
                         </div>
                       </div>
                          <div class="modal-footer">
                            <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                            <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit" id="submit-button">Add</button>
                          </div>
                      </form>
                  </div>
                </div>
              </div>

          <div class="modal fade" id="edit-style" tabindex="-1" role="dialog" aria-labelledby="modal-5">
                <div class="modal-dialog modal-dialog-centered" role="document">
                  <div class="modal-content">
                    <div class="modal-header bg-primary">
                      <h4 class="modal-title has-icon text-white">EDIT CATEGORY</h4>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>
                    <div class="modal-body">
                      <form class="form-horizontal" action="<?=site_url('restaurant/menu/editData')?>" method="post" id="edit-form">
                         <div class="form-group m-b-25">
                            <div class="form-group m-b-25">
                            <div class="col-12">
                               <label for="select">Name</label>
                               <input type="text" class="form-control" name="name" id="st_name" required>
                               <input type="hidden" name="menu_id" id="menu_id">
                            </div>
                       </div>
                         </div>
                       </div>
                          <div class="modal-footer">
                            <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                            <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit" id="submit-button">Update</button>
                          </div>
                      </form>
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>
    </div>
  </main>

 <?php $this->load->view('restaurant/includes/scripts');?>
  <script>
    $(document).ready(function() {
    $('#manage-restaurants').DataTable( {
         "order": [[ 0, "desc" ]], //or asc 
            "columnDefs" : [{"targets":3, "type":"date-eu"}],
    } );
} );
  </script>
  <script type="">
     function add()
      {
        $('#add-style').modal('show');
      }

      function edit(id)
      {
        $('#menu_id').val(id);
        // alert(id);
        $.ajax({
          method: "POST",
          url: "<?=site_url('restaurant/menu/getDetails');?>",
          data : { id : id },
          dataType : "json",
          success : function(data)
          {
            // alert(data.name);
            $('#st_name').val(data.name);
            $('#edit-style').modal('show');
          }
        });
      }
  </script>
</body>
</html>