<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('restaurant/includes/includes.php'); ?>
    <?php $this->load->view('restaurant/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">EXTRAS</h4>
                 
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                          <th width="10%">Image</th>
                          <th width="30%">Name</th>
                          <th width="10%">Item Code</th>
                          <th width="15%">Description</th>
                          <th width="10%">Price</th>
                          <th width="10%">Edit</th>
                          <th width="10%">Status</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach($extras as $ex) {?>
                        <tr>
                          <td>
                            <?php if($ex->image!=''){ ?>
                             <img src="<?=base_url().$ex->image?>" width="100%">
                            <?php } else { ?>  
                              <img src="<?=base_url()?>uploads/restaurant/extras/extras.jpg" width="100%">
                            <?php };?>
                          </td>
                          <td><?=$ex->name?></td>
                          <td><?=$ex->item_code?></td>
                          <td><?=$ex->description?></td>
                          <td><?=number_format($ex->price,'3')?> BHD</td>
                          <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="<?= site_url('restaurant/extras/edit/'.$ex->extra_id)?>">Edit</a></td>
                          <td>
                             <?php
                                    if ($ex->status=='1')
                                       {
                                         $status = "Active";
                                         $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$ex->extra_id.')">Block</a>';
                                       }
                                       elseif($ex->status=='0')
                                       {
                                         $status = "Blocked";
                                         $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$ex->extra_id.')">Activate</a>';
                                       }
                                    ?>
                              <?=$status.'<br>'.$action;?>
                          </td>
                        </tr>
                      <?php };?>  
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="disable-extra" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DISABLE EXTRA</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to disable this item?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/extras/disable')?>" method="post">
                      <input type="hidden" name="extra_id" id="disable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Disable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="enable-extra" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ENABLE EXTRA</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to enable this item?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/extras/enable')?>" method="post">
                      <input type="hidden" name="extra_id" id="enable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Enable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
      </div>
      <?php $this->load->view('restaurant/includes/footer.php'); ?>
    </div>
  </body>
  <?php $this->load->view('restaurant/includes/scripts.php'); ?>
  <?php $this->load->view('restaurant/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
   <script>
      function disable(c_id)
    	{
    		$('#disable_id').val(c_id);
    		$('#disable-extra').modal('show');
    	}
    	function enable(c_id)
    	{
    		$('#enable_id').val(c_id);
    		$('#enable-extra').modal('show');
    	}
    
  </script>
</html>
