<!DOCTYPE html>
<html>
   <head>
      <?php $this->load->view('restaurant/includes/includes.php'); ?>
      <?php $this->load->view('restaurant/includes/table-css.php'); ?>
   </head>
   <body>
      <div id="wrapper">
         <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
         <div class="content-page">
            <div class="content">
               <div class="container-fluid">
                  <div class="row">
                     <div class="col-12">
                        <div class="page-title-box">
                           <h4 class="page-title float-left">Cuisines</h4>
                           <ol class="breadcrumb float-right">
                              <button type="button" class="btn btn-gradient btn-rounded waves-light waves-effect w-md" data-toggle="modal" data-target="#add-style">Manage Cuisines</button>
                           </ol>
                           <div class="clearfix"></div>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="row">
                  <div class="col-12">
                     <div class="card-box table-responsive">
                        <table id="datatable" class="table table-bordered table-striped my-table">
                           <thead>
                              <tr>
                                 <th width="60%">Cuisine Name</th>
                                 <th width="20%">Status</th>
                                 <th width="20%">Delete</th>
                              </tr>
                           </thead>
                           <tbody>
							      <?php foreach($cuisines as $cu){?>
 			                    <tr>
 			                        <td><?=$cu->name?></td>
                                 <td>
                                    <?php if ($cu->stat=='1') { ?>
                                       Active
                                    <?php }else { ?>
                                       Deactivated
                                    <?php } ?>
                                 </td>
                                    <!--   if ($off->status) -->
                                    <!--      {-->
                                    <!--        $status = "Active";-->
                                    <!--        $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$off->offer_id.')" >Inactive</a>';-->
                                              
                                    <!--      }-->
                                    <!--      else -->
                                    <!--      {-->
                                    <!--        $status = "Blocked";-->
                                    <!--        $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$off->offer_id.')" >Active</a>';-->
                                    <!--      }-->
                                    <!--  ?>-->
 			                        <td><button class="btn btn-success btn-sm btn-rounded waves-light waves-effect" onclick="del('<?=$cu->rc_id?>')" style="font-size:11px;">Delete</button></td>
 			                    </tr>
 			                  <?php };?>
                           </tbody>
                        </table>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <?php $this->load->view('restaurant/includes/footer.php'); ?>
      </div>
      <div class="modal fade" id="add-style" role="dialog">
         <div class="modal-dialog">
            <div class="modal-content">
               <div class="modal-header">
                  <button type="button" class="close" data-dismiss="modal">&times;</button>
                  <h4 class="modal-title">MANAGE CUISINE</h4>
               </div>
               <div class="modal-body">
                  <form id="Myform" action="<?=site_url('restaurant/cuisines/addData')?>" method="post">
                     <div class="row">
						 <?php foreach ($types as $type) { ?>
							 <div class="col-md-6">
 	                           <div class="form-group">
								   <label class="ms-checkbox-wrap ms-checkbox-primary">
 	                                <input type="checkbox" name="cuisines[]" id="cuisine" value="<?=$type->c_id?>" <?php if($type->stat=='1') {?> checked <?php };?>> <i class="ms-checkbox-check"></i>
 	                              </label> <span> <?=$type->name?> </span>
 	                           </div>
 	                        </div>
						 <?php } ?>
                     </div>
               </div>
               <div class="modal-footer">
               <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
               <button type="submit" class="btn btn-success">Save</button>
               </form>
               </div>
            </div>
         </div>
      </div>
      
      <div class="modal fade" id="delete-cuisine" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DELETE CUISINE</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to delete this cuisine?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/cuisines/delete')?>" method="post">
                      <input type="hidden" name="c_id" id="del_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Delete</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
      
   </body>
   <?php $this->load->view('restaurant/includes/scripts.php'); ?>
   <?php $this->load->view('restaurant/includes/table-script.php'); ?>
    <script>
      function del(c_id)
    	{
    		$('#del_id').val(c_id);
    		$('#delete-cuisine').modal('show');
    	}
    
  </script>
  <script>
    $('#Myform').on('submit', function(e){
         e.preventDefault();
        if($('[type="checkbox"]').is(":checked"))
        {
              document.getElementById("Myform").submit();
              return true;
        }
        else
        {
             toastr.error("","Please select any one of the cuisnie.");   
        }
    }); 
  </script>
</html>
