<!DOCTYPE html>
<html>
   <head>
      <?php $this->load->view('restaurant/includes/includes.php'); ?>
      <?php $this->load->view('restaurant/includes/table-css.php'); ?>
   </head>
   <body>
      <div id="wrapper">
         <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
         <div class="content-page">
            <div class="content">
               <div class="container-fluid">
                  <div class="row">
                     <div class="col-12">
                        <div class="page-title-box">
                           <h4 class="page-title float-left">Manage Categories</h4>
                           <ol class="breadcrumb float-right">
                              <button type="button" class="btn btn-gradient btn-rounded waves-light waves-effect w-md" data-toggle="modal" data-target="#add-style">Add Category</button>
                           </ol>
                           <div class="clearfix"></div>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="row">
                  <div class="col-12">
                     <div class="card-box table-responsive">
                        <table id="datatable" class="table table-bordered table-striped my-table">
                           <thead>
                              <tr>
                                 <th width="60%">Category Name</th>
                                 <th width="20%">Status</th>
                                 <th width="20%">Edit</th>
                                 <th width="20%">Delete</th>
                              </tr>
                           </thead>
                           <tbody>
                              <?php $i=1; foreach($menu as $me){?>
                              <tr>
                                 <td><?=$me->name?></td>
                                 <?php
                                    if ($me->status)
                                       {
                                         $status = "Active";
                                         $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$me->menu_id.')" >Block</a>';
                                       }
                                       else
                                       {
                                         $status = "Blocked";
                                         $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$me->menu_id.')">Activate</a>';
                                       }
                                    ?>
                                 <td><?=$action;?></td>
                                 <td><button class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="edit('<?=$me->menu_id?>')">Edit</button></td>
                                 <td><button class="btn btn-danger btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="del('<?=$me->menu_id?>')">Delete</button></td>
                              </tr>
                              <?php $i++; };?>
                           </tbody>
                        </table>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <?php $this->load->view('restaurant/includes/footer.php'); ?>
      </div>
      <div class="modal fade" id="add-style" role="dialog">
         <div class="modal-dialog">
            <div class="modal-content">
               <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ADD CATEGORY</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <form id="add-form" action="<?=site_url('restaurant/categories/addData')?>" method="post">
                     <div class="row">
                        <div class="col-md-12">
                           <div class="form-group">
                              <label for="select">Name</label>
                              <input type="text" class="form-control" name="name" id="name" minlength="3" maxlength="100" required>
                           </div>
                        </div>
                     </div>
               </div>
               <div class="modal-footer">
               <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
               <button type="submit" class="btn btn-success">Add</button>
               </form>
               </div>
            </div>
         </div>
      </div>
      <div class="modal fade" id="edit-style" role="dialog">
         <div class="modal-dialog">
            <div class="modal-content">
               <div class="modal-header bg-primary">
                 <h4 class="modal-title has-icon text-white">EDIT CATEGORY</h4>
                 <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
               </div>
               <div class="modal-body">
                  <form id="add-form" action="<?=site_url('restaurant/categories/editData')?>" method="post">
					  <input type="hidden" name="menu_id" id="menu_id">
                     <div class="row">
                        <div class="col-md-12">
                           <div class="form-group">
                              <label for="select">Name</label>
                              <input type="text" class="form-control" name="name" id="st_name" minlength="3" maxlength="100" required>
                           </div>
                        </div>
                     </div>
               </div>
               <div class="modal-footer">
               <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
               <button type="submit" class="btn btn-success">Update</button>
               </form>
               </div>
            </div>
         </div>
      </div>
      
       <div class="modal fade" id="disable-cat" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DISABLE CATEGORY</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to disable this category?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/categories/disable')?>" method="post">
                      <input type="hidden" name="cat_id" id="disable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Disable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="enable-cat" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ENABLE CATEGORY</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to enable this category?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/categories/enable')?>" method="post">
                      <input type="hidden" name="cat_id" id="enable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Enable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="delete-cat" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DELETE CATEGORY</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to delete this category?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/categories/delete')?>" method="post">
                      <input type="hidden" name="cat_id" id="delete_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Delete</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
      
   </body>
   <?php $this->load->view('restaurant/includes/scripts.php'); ?>
   <?php $this->load->view('restaurant/includes/table-script.php'); ?>
   <script>
      function add()
      {
	     $('#add-style').modal('show');
      }
      function edit(id)
      {
	     $('#menu_id').val(id);
	     $.ajax({
	        method: "POST",
	        url: "<?=site_url('restaurant/categories/getDetails');?>",
	        data : { id : id },
	        dataType : "json",
	        success : function(data)
	        {
		        $('#st_name').val(data.name);
		        $('#edit-style').modal('show');
	        }
	     });
      }
   </script>
   <script>
      function disable(c_id)
    	{
    		$('#disable_id').val(c_id);
    		$('#disable-cat').modal('show');
    	}
    	function enable(c_id)
    	{
    		$('#enable_id').val(c_id);
    		$('#enable-cat').modal('show');
    	}
        function del(c_id)
    	{
    		$('#delete_id').val(c_id);
    		$('#delete-cat').modal('show');
    // alert(c_id);
    	}
  </script>
</html>
