<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('restaurant/includes/includes.php'); ?>
    <?php $this->load->view('restaurant/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">BRANCHES</h4>
                 
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable1" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                          <th width="10%">Branch Code</th>
                          <th width="10%">Branch Name</th>
                          <th width="20%">Email</th>
                          <th width="15%">Phone</th>
                          <th width="30%">Address</th>
                          <th width="15%">Password</th>
                          <th width="10%">Edit</th>
                          <th width="10%">Status</th>
                          <th width="10%">Details</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach($branches as $br) {?>
                        <tr>
                          <td><?=$br->branch_code?></td>
                          <td><?=$br->branch_name?></td>
                          <td><?=$br->email?></td>
                          <td><?=$br->phone?></td>
                          <td><?=$br->address?></td>
                          <td>
                              <button type="button" style="font-size:12px;" class="btn btn-success btn-sm btn-rounded waves-light waves-effect" onclick="change_password('<?=$br->b_id?>')">Change Password</button>
                          </td>
                          <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="<?= site_url('restaurant/branches/edit/'.$br->b_id)?>">Edit</a></td>
                          <td>
                             <?php
                                    if ($br->status=='1')
                                       {
                                         $status = "Active";
                                         $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$br->b_id.')"  >Block</a>';
                                       }
                                       elseif($br->status=='0')
                                       {
                                         $status = "Blocked";
                                         $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$br->b_id.')"  >Activate</a>';
                                       }
                                    ?>
                              <?=$status.'<br>'.$action;?>
                          </td>
                          <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="<?= site_url('restaurant/branches/details/'.$br->b_id)?>">View</a></td>
                        </tr>
                      <?php };?>  
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('restaurant/includes/footer.php'); ?>

      <div id="change_password" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="custom-width-modalLabel" aria-hidden="true" style="display: none;">
          <div class="modal-dialog">
              <div class="modal-content">

                  <div class="modal-body">
                      <h2 class="text-uppercase text-center m-b-30">
                        <span><h4>Change password</h4></span>
                      </h2>
                      <form id="form-password" class="form-horizontal" action="<?=site_url('restaurant/branches/changePassword')?>" method="post">
                          <div class="form-group m-b-25">
                              <div class="col-12">
                                  <label for="select">New Password</label>
                                  <input type="password" name="password" id="password1" class="form-control" pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{6,}" title="Must contain at least one number and one uppercase and lowercase letter, and at least 6 or more characters" maxlength="16" required>
                              </div>
                          </div>
                          <input type="hidden" name="branch_id" id="branch_id">
                          <div class="form-group m-b-25">
                              <div class="col-12">
                                  <label for="select">Confirm Password</label>
                                  <input type="password"  id="password2" class="form-control" pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{6,}" title="Must contain at least one number and one uppercase and lowercase letter, and at least 6 or more characters" maxlength="16" required>
                              </div>
                          </div>
                          <div class="" style="text-align:center;color:red;padding-bottom:10px;" id="message">
                          </div>
                          <div class="form-group account-btn text-center m-t-10">
                              <div class="col-12">
                                  <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                                  <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Change</button>
                              </div>
                          </div>
                      </form>
                    </div>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div>
        
        <div class="modal fade" id="disable-branch" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DISABLE BRANCH</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to disable this branch?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/branches/disable')?>" method="post">
                      <input type="hidden" name="branch_id" id="disable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Disable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="enable-branch" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ENABLE BRANCH</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to enable this branch?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/branches/enable')?>" method="post">
                      <input type="hidden" name="branch_id" id="enable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Enable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>

    </div>
  </body>
  <?php $this->load->view('restaurant/includes/scripts.php'); ?>
  <?php $this->load->view('restaurant/includes/table-script.php'); ?>
  <script type="text/javascript">
     $(document).ready(function() {
     var table = $('#datatable1').DataTable({
           "ordering": false,
          //  "searchPane": true,
           "columnDefs":[
          {
            "target":[1],
            "orderable":false
            // searchPanes:{
            //     options:[
            //         {
            //             label: 'Over 60',
            //             value: function(rowData, rowIdx) {
            //                 return rowData[0] > 60;
            //             }
            //         }
            //     ]
            // },
            // targets: [0]
          }
        ]
          
           });
           table.buttons().container()
                .appendTo('#datatable1-buttons_wrapper .col-md-6:eq(0)');
      } );

  </script> 
  <script>
  function change_password(key)
  {
    $('#branch_id').val(key);
    $('#change_password').modal('show');
  }
</script>
 <script type="">
    $('#form-password').on('submit', function(e){
       e.preventDefault();
      // CODE HERE
      var pass1 = $('#password1').val();
      // alert(pass1);
      var length = pass1.length;
      if (length < 6) 
      {
        toastr.error("Password should contain atleast 6 characters..!");
        return false;
      }
      else 
      {
        var pass2 = $('#password2').val();
        if (pass1 == pass2) 
        {
          document.getElementById("form-password").submit();
          return true;
        }
        else 
        {
          toastr.error("Password mismatch"); 
          return false;
        }
      }         
    });
  </script>
  <script>
      function disable(c_id)
    	{
    		$('#disable_id').val(c_id);
    		$('#disable-branch').modal('show');
    	}
    	function enable(c_id)
    	{
    		$('#enable_id').val(c_id);
    		$('#enable-branch').modal('show');
    	}
    
  </script>
</html>
