<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('restaurant/includes/includes.php'); ?>
    <?php $this->load->view('restaurant/includes/table-css.php'); ?>
    <link rel="stylesheet" href="<?=base_url()?>plugins/image-crop/croppie.css">
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">Add Branch</h4>
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
              <div class="card-box">
                <form action="<?=site_url('restaurant/branches/addData')?>" method="post" id="Myform">

                   <div class="form-row">
                      <div class="col-md-6">
                        <label for="validationCustom02">Email Address<span style="color: red;">*</span></label>
                        <div class="input-group">
                          <input type="text"  name="email" id="email" class="form-control" placeholder="Email Address" required>
                        </div>
                      </div>
                      <div class="col-md-6">
                        <label>Phone<span style="color: red;">*</span></label>
                        <div class="input-group">
                          <input type="text" name="phone" id="phone" minlength="3" class="form-control"  placeholder="Phone"  required>
                        </div>
                      </div>
                    </div>
                    <br>
                    <div class="form-row">
                      <div class="col-md-6">
                        <label for="validationCustom02">Branch Code<span style="color: red;">*</span></label>
                        <div class="input-group">
                          <input type="text"  name="code" id="code" class="form-control"  placeholder="Branch Code" required>
                        </div>
                      </div>
                      <div class="col-md-6">
                        <label for="validationCustom02">Branch Name<span style="color: red;">*</span></label>
                        <div class="input-group">
                          <input type="text"  name="branch_name" id="branch_name" class="form-control"  placeholder="Branch Code" required>
                        </div>
                      </div>
                    </div>
                    <br>
                    <div class="form-row">
                        <div class="col-md-6">
                          <label>Restaurant Open Time<span style="color: red;">*</span></label>
                          <div class="input-group">
                            <input type="time" name="open_time" class="form-control" value="00:00:00" required>
                          </div>
                        </div>
                        <div class="col-md-6">
                          <label>Restaurant Close Time<span style="color: red;">*</span></label>
                          <div class="input-group">
                            <input type="time" name="close_time" class="form-control" value="23:59:00" required>
                          </div>
                        </div>
                    </div>
                    <br>
                    <div class="form-row">
                      <div class="col-md-12">
                        <label>Address<span style="color: red;">*</span></label>
                        <div class="input-group">
                          <textarea type="text" name="address_1" class="form-control"  placeholder="Address" required></textarea>
                        </div>
                      </div>
                    </div>
                    <br>
                    <div class="form-row">
                        <div class="col-md-12">
                          <label>Location<span style="color: red;">*</span></label>
                          <div class="input-group">
                            <input id="searchTextField" class="form-control" name="landmark" type="text" size="50" placeholder="Enter a location" autocomplete="on" runat="server"  required/>  
                          </div>
                        </div>
                    </div>
                    <br>
                    <div class="form-row">
                      <div class="col-md-6">
                        <label>Latitude<span style="color: red;">*</span></label>
                        <div class="input-group">
                          <input type="text" id="cityLat" name="latitude" class="form-control"  placeholder="Latitude" required readonly />
                        </div>
                      </div>
                      <div class="col-md-6">
                        <label>Longitude<span style="color: red;">*</span></label>
                        <div class="input-group">
                          <input type="text" id="cityLng" name="longitude" class="form-control"  placeholder="Longitude" required readonly />
                        </div>
                      </div>
                    </div>
                    <br>
                    <div class="form-row">
                        <div class="col-md-6">
                          <label>City<span style="color: red;">*</span></label>
                          <div class="input-group">
                            <!--<input type="text" name="city" class="form-control"  placeholder="City" required>-->
                            <select class="form-control" name="city" required>
                               <option value="">---Select City---</option>
                               <?php foreach($places as $place) {?>
                                 <option vaue="<?=$place->place_id?>"><?=$place->name?></option>
                               <?php };?>
                            </select>
                          </div>
                        </div>
                        <div class="col-md-6">
                            <label>Country<span style="color: red;">*</span></label>
                            <div class="input-group">
                              <select class="form-control" name="country" id="country">
                                <option value="Bahrain">Bahrain</option>
                              </select>
                            </div>
                         </div>
                    </div>
                    <br>
                    <div class="form-row">
                      <!--<div class="col-md-6">-->
                      <!--  <label>Pincode</label>-->
                      <!--  <div class="input-group">-->
                      <!--    <input type="text" name="pincode" class="form-control"  placeholder="Pincode" >-->
                      <!--  </div>-->
                      <!--</div>-->
                      
                       <div class="col-md-6">
                          <label>Password (Note: Password must contain at least one number and one uppercase and lowercase letter, and at least 6 or more characters. )<span style="color: red;">*</span></label>
                          <div class="input-group">
                            <input type="password" name="password" id="password" class="form-control" pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{6,}" title="Must contain at least one number and one uppercase and lowercase letter, and at least 6 or more characters" maxlength="16" placeholder="Password" required>
                          </div>
                       </div> 
                    </div>
                  
                    <div class="form-row">
                      <div class="col-md-12 mt-4">
                        <button type="submit" class="btn btn-success waves-light waves-effect w-md pull-right" id="submit-button" style="display:block;">Add</button>
                      </div>
                    </div>  
                 </div>

                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('restaurant/includes/footer.php'); ?>
    </div>
  </body>
  <?php $this->load->view('restaurant/includes/scripts.php'); ?>
  <script src="<?=base_url()?>plugins/image-crop/croppie.js"></script>

   <script type="">
        $('#Myform').on('submit', function(e){
         e.preventDefault();    
          phone      = $('#phone').val();
          email      = $('#email').val();
          code       = $('#code').val();
          password   = $('#password').val();
          lat        = $('#cityLat').val();
          long       = $('#cityLng').val();
          var regex    = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
          var pattern  = /^[3,6]{1}[0-9]{7}$/;
          
    //       if (phone.length < 8) 
    //       {
    // 	     	toastr.error('Mobile number should contains atleast 8 numbers');
    // 	  }
    // 	  else if(!pattern.test(phone)) 
    // 	    {
    //             toastr.error('Mobile number should be start with 3 0r 6');
    //         }
    	  if(!regex.test(email))
	  	  {
	  	    toastr.error('Please enter a vaild email id');
	  	  }
    	  else if(password.length < 6)
    	  {
    		  	toastr.error('Password should contains atleast 6 characters');
    	  }
    	  else if (lat == '') 
          {
              toastr.error('Latitude should not be empty. Please select a valid location');
          }
          else if (long == '') 
          {
              toastr.error('Logitude should not be empty. Please select a valid location');
          }
    	  else
    	  {
              $.ajax({
                  method: "POST",
                  url: "<?php echo site_url('restaurant/branches/checkBranch');?>",
                  dataType : "json",
                  data : { phone      : phone,
                           email      : email,
                           code       : code
                         },
                  success : function( data )
                  {
                    if (data == 0) 
                    {
                      document.getElementById("Myform").submit();
                      return true;
                    }
                    else if(data== 1)
                    {
                      toastr.error("","Phone number already exists");         
                    }   
                    else if(data== 2)
                    {
                      toastr.error("","Email already exists");           
                    } 
                    else if(data== 3)
                    {
                      toastr.error("","Code already exists");           
                    } 
                  }             
                });  
    	  }        
      });
  </script>
   <script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAfnTZTvak3CmT0mL-G5rbVNDakshdDnvg&libraries=places"></script>
    <script>
        function initialize() {
          var input = document.getElementById('searchTextField');
          var autocomplete = new google.maps.places.Autocomplete(input);
            google.maps.event.addListener(autocomplete, 'place_changed', function () {
                var place = autocomplete.getPlace();
                document.getElementById('cityLat').value = place.geometry.location.lat();
                document.getElementById('cityLng').value = place.geometry.location.lng();
            });
        }
        google.maps.event.addDomListener(window, 'load', initialize);
    </script>
</html>
