<!DOCTYPE html>
<html>
   <head>
      <?php $this->load->view('restaurant/includes/includes.php'); ?>
      <?php $this->load->view('restaurant/includes/table-css.php'); ?>
   </head>
   <body>
      <div id="wrapper">
         <?php $this->load->view('restaurant/includes/sidebar.php'); ?>
         <div class="content-page">
            <div class="content">
               <div class="container-fluid">
                  <div class="row">
                     <div class="col-12">
                        <div class="page-title-box">
                           <h4 class="page-title float-left">Blocks</h4>
                           <ol class="breadcrumb float-right">
                              <a href="<?=site_url('restaurant/blocks/manage')?>"><button type="button" class="btn btn-gradient btn-rounded waves-light waves-effect w-md">Manage Blocks</button></a>
                           </ol>
                           <div class="clearfix"></div>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="row">
                  <div class="col-12">
                     <div class="card-box table-responsive">
                        <table id="datatable" class="table table-bordered table-striped my-table">
                           <thead>
                              <tr>
                                 <th width="60%">Block Number</th>
                                 <th width="20%">Place Name</th>
                                 <th width="20%">City</th>
                                 <th width="20%">Delete</th>
                              </tr>
                           </thead>
                           <?php if($blocks){ ?>
                           <tbody>
							      <?php foreach($blocks as $block){?>
 			                    <tr>
 			                        <td><?=$block->block_name?></td>
                                    <td><?=$block->place_name?></td>
                                    <td><?=$block->name?></td>
 			                        <td><button class="btn btn-success btn-sm btn-rounded waves-light waves-effect" onclick="del('<?=$block->bdb_id?>')" style="font-size:11px;">Delete</button></td>
 			                    </tr>
 			                  <?php };?>
                           </tbody>
                           <?php } else { ?>  
                              <tbody>
							     
 			                    <tr>
                              <th> No Blocks found<th>
                              <th> <th>
                             
                                  
 			                    </tr>
 			                 
                           </tbody>
                           <?php };?>
                        </table>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <?php $this->load->view('restaurant/includes/footer.php'); ?>
      </div>

      <div class="modal fade" id="delete-cuisine" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DELETE CUISINE</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to delete this block?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('restaurant/blocks/delete')?>" method="post">
                      <input type="hidden" name="block_id" id="del_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Delete</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
      
   </body>
   <?php $this->load->view('restaurant/includes/scripts.php'); ?>
   <?php $this->load->view('restaurant/includes/table-script.php'); ?>
    <script>
      function del(c_id)
    	{
    		$('#del_id').val(c_id);
    		$('#delete-cuisine').modal('show');
    	}
    
  </script>
  <script>
    $('#Myform').on('submit', function(e){
         e.preventDefault();
        if($('[type="checkbox"]').is(":checked"))
        {
              document.getElementById("Myform").submit();
              return true;
        }
        else
        {
             toastr.error("","Please select any one of the cuisnie.");   
        }
    }); 
  </script>
</html>
