<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('branch/includes/includes.php'); ?>
    <?php $this->load->view('branch/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('branch/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">PROMOTIONS</h4>
                 
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                          <th width="10%">Image</th>
                          <th width="20%">Promotion Code</th>
                          <th width="30%">Title</th>
                          <th width="25%">Price</th>
                          <th width="15%">Description</th>
                          <th width="5%">Details</th>
                          <th width="5%">Status</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach($promotions as $promo) {?>
                        <tr>
                          <td>
                            <?php if($promo->image!='') {?>
                              <img src="<?=base_url().$promo->image;?>" width="100%">
                            <?php } else {?>
                              <img src="<?=base_url()?>uploads/restaurant/promotion/default.svg" width="100%">  
                            <?php };?>
                          </td>    
                          <td><?=$promo->code?></td>    
                          <td><?=$promo->title?></td>
                          <td><?=number_format($promo->price,'2')?> BHD</td>
                          <td><?=$promo->description?></td>
                          <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="<?= site_url('branch/promotions/details/'.$promo->pr_id)?>">View</a></td>
                          <td>
                             <?php
                                    if ($promo->status=='1')
                                       {
                                         $status = "Active";
                                         $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$promo->bp_id.')" >Block</a>';
                                       }
                                       elseif($promo->status=='0')
                                       {
                                         $status = "Blocked";
                                         $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$promo->bp_id.')">Activate</a>';
                                       }
                                       else
                                       {
                                            $status = "Requested";
                                            $action = '';
                                       }
                                    ?>
                              <?=$status.'<br>'.$action;?>
                          </td>
                        </tr>
                      <?php };?>  
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="disable-product" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DISABLE PRODUCT</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to disable this product?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('branch/promotions/disable')?>" method="post">
                      <input type="hidden" name="promo_id" id="p_disable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Disable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="enable-product" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ENABLE PRODUCT</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to enable this product?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('branch/promotions/enable')?>" method="post">
                      <input type="hidden" name="promo_id" id="p_enable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Enable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
      </div>
      <?php $this->load->view('branch/includes/footer.php'); ?>
    </div>
  </body>
  <?php $this->load->view('branch/includes/scripts.php'); ?>
  <?php $this->load->view('branch/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
   <script>
      function disable(p_id)
    	{
    		$('#p_disable_id').val(p_id);
    		$('#disable-product').modal('show');
    	}
    	function enable(p_id)
    	{
    		$('#p_enable_id').val(p_id);
    		$('#enable-product').modal('show');
    	}
  </script>
</html>
