<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('branch/includes/includes.php'); ?>
    <?php $this->load->view('branch/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('branch/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">PROMOTIONS</h4>
                  <!--<ol class="breadcrumb float-right">-->
                  <!--  <button type="button" class="btn btn-gradient btn-rounded waves-light waves-effect w-md" onclick="add()">Add Promotion</button>-->
                  <!--</ol>-->
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
               <div class="col-md-12">
                    <div class="card-box">
                        <h4 class="header-title m-t-0 m-b-30"><?=$promotion->title?></h4>

                        <ul class="nav nav-pills navtab-bg nav-justified">
                            <li class="nav-item">
                                <a href="#home1" data-toggle="tab" aria-expanded="false" class="nav-link active">
                                    Basic Details
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="#profile1" data-toggle="tab" aria-expanded="true" class="nav-link">
                                    Products
                                </a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane show active" id="home1">
                                <table class="table ms-profile-information">
                                    <tbody>
                                        <tr>
				                          <th scope="row">Promotion Code</th>
				                          <td><?=$promotion->code?></td>
				                        </tr>
				                        <tr>
				                          <th scope="row">Price</th>
				                          <td><?=number_format($promotion->price,'2')?> BHD</td>
				                        </tr> 
				                        <tr>
				                          <th scope="row">Description</th>
				                          <td><?=$promotion->description?></td>
				                        </tr>
				                        <tr>
				                          <th scope="row">Status</th>
				                          <td><?php if($promotion->status=='active') { echo "Active"; } elseif($promotion->status=='blocked') { echo "Blocked"; } else { echo "Requested"; }?></td>
				                        </tr>
				                        <tr>
				                          <th scope="row">Image</th>
				                          <td><?php if($promotion->image!='') {?>
                                                <img src="<?=base_url().$promotion->image;?>" width="10%">
                                              <?php }else {?>
                                                 <img src="<?=base_url()?>uploads/restaurant/promotion/default.svg" width="10%">  
                                              <?php };?>
                                          </td>
				                        </tr>
				                     </tbody>        
                                </table>
                            </div>
                            <div class="tab-pane" id="profile1">
                              <?php foreach($promotion_category as $cat) {?>    
                                <p><b><?=$cat->name?></b>
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                         <tr>
                                             <th>Name</th>
                                             <th>Item Code</th>
                                          </tr>
                                        </thead>
                                        <tbody>
                                         <?php foreach($cat->products as $product) {?>    
                                            <tr>
                                               <td><?=$product->name?></td> 
                                               <td><?=$product->code?></td>
                                            </tr>
                                         <?php };?>    
                                        </tbody>
                                   </table>
                                </p>
                              <?php };?>    
                            </div>
                           
                        </div>
                    </div>
                </div> <!-- end col -->
            </div>
        </div>
      </div>
      <?php $this->load->view('branch/includes/footer.php'); ?>
      

    </div>
  </body>
  <?php $this->load->view('branch/includes/scripts.php'); ?>
  <?php $this->load->view('branch/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 

</html>
