<!DOCTYPE html>
<html>
   <head>
      <?php $this->load->view('branch/includes/includes.php'); ?>
      <?php $this->load->view('branch/includes/table-css.php'); ?>
   </head>
   <body>
      <div id="wrapper">
         <?php $this->load->view('branch/includes/sidebar.php'); ?>
         <div class="content-page">
            <div class="content">
               <div class="container-fluid">
                  <div class="row">
                     <div class="col-12">
                        <div class="page-title-box">
                           <h4 class="page-title float-left">Manage profile</h4>
						   <ol class="breadcrumb float-right">
                              <!--<button type="button" class="btn btn-gradient btn-rounded waves-light waves-effect w-md" onclick="edit('<?=$rest->r_id?>')">Edit profile</button>-->
                              <?php if($branch->branch_type==1){?>
							  <a href="<?=site_url('branch/profile/edit')?>"><button type="button" class="btn btn-gradient btn-rounded waves-light waves-effect w-md" >Edit profile</button></a>
							  <?php }?>
							</ol>
						   <div class="clearfix"></div>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="row">
                  <div class="col-md-6">
                     <div class="card-box table-responsive">
						 <table class="table ms-profile-information">
	                       <tbody>
	                         <tr>
	                           <th scope="row">Restaturant Name</th>
	                           <td><?=$rest->rest_name?></td>
	                         </tr>
							 <?php if($branch->branch_type == '2'){?>
							 <tr>
	                           <th scope="row">Branch Name</th>
	                           <td><?=$rest->rest_name?></td>
	                         </tr>
							 <?php }else{?>
								<tr>
	                           <th scope="row">Branch Name</th>
	                           <td><?=$branch->branch_name?></td>
	                         </tr>
							 <?php }?>
	                         <tr>
	                           <th scope="row">Branch Code</th>
	                           <td><?=$branch->branch_code?></td>
	                         </tr>
	                         <tr>
	                           <th scope="row">Email Address</th>
	                           <td><?=$branch->email?></td>
	                         </tr>
	                         <tr>
	                           <th scope="row">Phone Number</th>
	                           <td><?=$branch->phone?></td>
	                         </tr>
	                         <tr>
	                           <th scope="row">Open Time</th>
	                           <td><?php echo date('h:i A',strtotime($branch->open_time));?></td>
	                         </tr>
	                         <tr>
	                           <th scope="row">Close Time</th>
	                           <td><?php echo date('h:i A',strtotime($branch->close_time));?></td>
	                         </tr>
	                         <tr>
	                           <th scope="row">Location</th>
	                           <td><?=$branch->location?></td>
	                         </tr>

	                       </tbody>
	                     </table>
	                     <label scope="row"><b>Restaurant Image</b></label>
						 <img src="<?=base_url() . $rest->rest_image?>" width="100%">
                     </div>
                  </div>
				  <div class="col-md-6">
                     <div class="card-box table-responsive">
						 <h5 class="section-title">Address</h5>
	                     <p>
	                       <?=$branch->address?><br>
	                      
	                     </p>

	                     <div class="ms-profile-skills">
	                       <h5 class="section-title">Cuisines</h5>
	                       <?php if(count($types)==0) {?>
                             <i>No Cuisines</i> <br>
                             <?php } else { ?>
                            <ul class="ms-skill-list">
                             <?php foreach($types as $type) {?>  
                              <li class="ms-skill"><?=$type->name?></li>
                            <?php } };?>
                            </ul>
                           
                           <br>  
                           <label scope="row"><b>Cover Image</b></label>
						   <img src="<?=base_url() . $rest->cover_image?>" width="100%">
	                     </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <?php $this->load->view('branch/includes/footer.php'); ?>
      </div>
      <div class="modal fade" id="edit-profile" role="dialog">
         <div class="modal-dialog">
            <div class="modal-content">
               <div class="modal-header">
                  <button type="button" class="close" data-dismiss="modal">&times;</button>
                  <h4 class="modal-title">EDIT PROFILE</h4>
               </div>
               <div class="modal-body">
                  <form action="<?=site_url('branch/profile/editData')?>" method="post" id="edit-form" enctype="multipart/form-data">
                     <div class="row">
						 
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Phone</label>
	 						   <input type="text" class="form-control" name="phone" id="phone" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" maxlength="9" required>
	 						   <input type="hidden" name="branch_id" id="branch_id">
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Email</label>
	 						   <input type="email" class="form-control" name="email" id="email" required>
							</div>
						</div>
						<!-- <div class="col-md-12">
							<div class="form-group">
								<label for="select">Open Time</label>
	 						   <input type="time" class="form-control" name="open_time" id="open_time" required>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Close Time</label>
	 						   <input type="time" class="form-control" name="close_time" id="close_time" required>
							</div>
						</div> -->
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Latitude</label>
	 						   <input type="text" class="form-control" name="latitude" id="latitude" required>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Longitude</label>
	 						   <input type="text" class="form-control" name="longitude" id="longitude" required>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Address</label>
	 						   <textarea type="text" class="form-control" name="address" id="address" required></textarea> 
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
							   <label for="select">Location</label>
	 						   <input type="text" class="form-control" name="landmark" id="landmark" required>
							</div>
						</div>
					
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">City</label>
	 						   <input type="text" class="form-control" name="city" id="city" required>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Country</label>
	 						   <input type="text" class="form-control" name="country" id="country" required>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
								<label for="select">Pincode</label>
	 						   <input type="text" class="form-control" name="pincode" id="pincode" required>
							</div>
						</div>
                     </div>
               </div>
               <div class="modal-footer">
               <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
               <button type="submit" class="btn btn-success">Update</button>
               </form>
               </div>
            </div>
         </div>
      </div>
   </body>
   <?php $this->load->view('branch/includes/scripts.php'); ?>
   <?php $this->load->view('branch/includes/table-script.php'); ?>
   <script type="">
	 function edit(id)
	 {
	   $('#branch_id').val(id);
	   $.ajax({
		 method: "POST",
		 url: "<?=site_url('branch/profile/getProfileById');?>",
		 data : { id : id },
		 dataType : "json",
		 success : function(data)
		 {
		   $('#phone').val(data.phone);
		   $('#email').val(data.email);
		   $('#address').val(data.address);
		   $('#latitude').val(data.latitude);
		   $('#longitude').val(data.longitude);
		   $('#pincode').val(data.pincode);
		   $('#country').val(data.country);
		   $('#state').val(data.state);
		   $('#city').val(data.city);
		   $('#landmark').val(data.location);
		   $('#edit-profile').modal('show');
		 }
	   });
	 }

   function preview_image(id)
   {
	 var id = id.id;
	 var x = document.getElementById(id);
	 var size = x.files[0].size;
	 if (size > 5000000)
	 {
	   toastr.error("Please select an image with size less than 5 mb.");
	   document.getElementById(id).value = "";
	 }
	 else
	 {
	   var val = x.files[0].type;
	   var type = val.substr(val.indexOf("/") + 1);
	   s_type = ['jpeg','jpg','png'];
	   var flag = 0;
	   for (var i = 0; i < s_type.length; i++)
	   {
		 if (s_type[i] == type)
		 {
		   flag = flag + 1;
		 }
	   }
	   if (flag == 0)
	   {
		 toastr.error("This file format is not supported.");
		 document.getElementById(id).value = "";
	   }
	   else
	   {
		 var reader = new FileReader();
		 reader.onload = function()
		 {
		   var cn = id.substring(3);
		   var preview = 'preview' + cn;
		   var output = document.getElementById(preview);
		   output.src = reader.result;
		 }
		 reader.readAsDataURL(x.files[0]);
	   }
	 }
   }
   </script>
</html>
