<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('branch/includes/includes.php'); ?>
    <?php $this->load->view('branch/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('branch/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">PRODUCTS</h4>
                 
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                          <th width="10%">Image</th>
                          <th width="30%">Name</th>
                          <th width="25%">Price</th>
                          <th width="15%">Category</th>
                          <th width="5%">Details</th>
                          <th width="5%">Status</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach($products as $pro) {?>
                        <tr>
                          <td><img src="<?=base_url().$pro->cover_image?>" width="100%"></td>
                          <td><?=$pro->name?></td>
                          <td><?php foreach($pro->prices as $price) { if($price->unit!='') { echo $price->unit; ?> - <?php echo number_format($price->price,'2'); } else { echo number_format($price->price,'2'); }; ?> BHD <br><?php };?></td>
                          <td><?=$pro->category?></td>
                          <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="<?= site_url('branch/products/details/'.$pro->product_id)?>">View</a></td>
                          <td>
                             <?php
                                    if ($pro->status=='1')
                                       {
                                         $status = "Active";
                                         $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$pro->bp_id.')" >Disable</a>';
                                       }
                                       elseif($pro->status=='0')
                                       {
                                         $status = "Blocked";
                                         $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$pro->bp_id.')" >Enable</a>';
                                       }
                                    ?>
                              <?=$status.'<br>'.$action;?>
                          </td>
                        </tr>
                      <?php };?>  
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="disable-product" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DISABLE PRODUCT</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to disable this product?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('branch/products/disable')?>" method="post">
                      <input type="hidden" name="product_id" id="p_disable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Disable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="enable-product" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ENABLE PRODUCT</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to enable this product?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('branch/products/enable')?>" method="post">
                      <input type="hidden" name="product_id" id="p_enable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Enable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
      </div>
      <?php $this->load->view('branch/includes/footer.php'); ?>
    </div>
  </body>
  <?php $this->load->view('branch/includes/scripts.php'); ?>
  <?php $this->load->view('branch/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
   <script>
      function disable(p_id)
    	{
    		$('#p_disable_id').val(p_id);
    		$('#disable-product').modal('show');
    	}
    	function enable(p_id)
    	{
    		$('#p_enable_id').val(p_id);
    		$('#enable-product').modal('show');
    	}
  </script>
</html>
