<!DOCTYPE html>
<html>
   <head>
      <?php $this->load->view('branch/includes/includes.php'); ?>
      <?php $this->load->view('branch/includes/table-css.php'); ?>
   </head>
   <body>
      <div id="wrapper">
         <?php $this->load->view('branch/includes/sidebar.php'); ?>
         <div class="content-page">
            <div class="content">
               <div class="container-fluid">
                  <div class="row">
                     <div class="col-12">
                        <div class="page-title-box">
                           <h4 class="page-title float-left"><?=$pro->name?></h4>
						   
						   <div class="clearfix"></div>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="row">
                  <div class="col-xl-6 col-md-12">
                  	<div class="ms-panel ms-panel-fh">
                         <div class="ms-panel-body">
		                     <div class="card-box table-responsive">
								 <table class="table ms-profile-information">
				                      <tbody>
				                        <tr>
				                          <th scope="row">Price</th>
				                          <td>
				                          <?php foreach($prices as $price) {?>
				                             <?php if($price->unit!='') { echo $price->unit; ?> &nbsp;- &nbsp;<?php echo number_format($price->price,'2'); } else { echo number_format($price->price,'2'); };?> BHD <br>
				                          <?php };?> 
				                          </td>
				                        </tr>
				                        <tr>
				                          <th scope="row">Category</th>
				                          <td><?=$menu?></td>
				                        </tr>
				                        <tr>
				                          <th scope="row">Preperation Time(In Minutes)</th>
				                          <td><?=$pro->prep_time?></td>
				                        </tr>
				                        <tr>
				                          <th scope="row">Status</th>
				                          <td><?php if($pro->status=='active') { echo "Active"; } elseif($pro->status=='blocked') { echo "Blocked"; } else { echo "Sold out"; }?></td>
				                        </tr>
				                        <tr>
				                          <th scope="row">Cover Image</th>
				                          <td><img src="<?=base_url().$pro->cover_image?>" width="100%"></td>
				                        </tr>
				                      </tbody>
			                     </table>
		                     </div>
		                   </div>  
                       </div>
                  </div>
				  <div class="col-md-6">
                     <div class="card-box table-responsive">
						 <h5 class="section-title">Description</h2>
	                     <p><?=$pro->description?></p>
	                     <hr>
	                     <?php if(count($categories)>0) { ?>
	                     <div class="ms-profile-skills">
	                      <h5 class="section-title">Product Choices</h2>
	                      <ul class="ms-skill-list">
	                       <?php foreach($categories as $cat) {?>  
	                        <li><b><?=$cat->cat_name?> - <?php if($cat->type=='1') {?> Single Type <?php } else {?> Multiple Type <?php };?></b></li>
	                        <?php foreach($cat->choices as $choice) {?>
	                         <i><?=$choice->name?> <?php if($choice->price!='0') {?>- <?=number_format($choice->price,2)?> BHD <?php };?></i> <br>
	                       <?php } };?> 
	                      </ul>
	                     </div>
	                     <?php };?>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <?php $this->load->view('branch/includes/footer.php'); ?>
      </div>
      
   </body>
   <?php $this->load->view('branch/includes/scripts.php'); ?>
   <?php $this->load->view('branch/includes/table-script.php'); ?>
  
</html>
