<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('branch/includes/includes.php'); ?>
    <?php $this->load->view('branch/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('branch/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">New Orders</h4>
                  
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th width="10%">Order No.</th>
                            <th width="15%">Customer Details</th>
                            <th width="15%">Ordered On</th>
                            <th width="25%">Delivery Address</th>
                            <th width="10%">Price(BHD)</th>
                            <!--<th width="10%">Order Status</th>-->
                            <th width="5%">Details</th>
                            <th width="15%">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                            <?php foreach($orders as $order) {?>
                              <tr>
                                <td>ORD<?=$order->order_id?></td>
                                <td><?=$order->username?><br>
                                    <?=$order->useremail?><br>
                                    <?=$order->userphone?>
                                </td>
                                <td><?php echo date('d M Y',strtotime($order->ordered_date));?><br><?=$order->ordered_time?></td>
                                <td>
                                  <?=$order->area?><br>
                                  <?=$order->block?>, <?=$order->road_no?>, <?=$order->building?>, <?=$order->floor?>, <?=$order->flat?><br>
                                  <?=$order->mobile?>
                                </td>
                                <td><?=number_format($order->total,'3')?> BD</td>
                                <!--<td>Order Placed</td>-->
                                <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:13px;" href="<?=site_url('branch/orders/details/'.$order->order_id)?>" >View</a></td>
                                <td>
                                  <a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:13px;" onclick="approve('<?=$order->order_id?>')">Approve</a><br><br>
                                  <a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:13px;" onclick="reject('<?=$order->order_id?>')">Reject</a>
                                </td>
                              </tr>
                            <?php };?>
                       
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      
       <div class="modal fade" id="approve-order" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">APPROVE ORDER</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to approve this order?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('branch/orders/approve')?>" method="post">
                      <input type="hidden" name="order_id" id="disable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Approve</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="reject-order" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">REJECT ORDER</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to reject this order?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('branch/orders/reject')?>" method="post">
                      <input type="hidden" name="order_id" id="enable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Reject</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
      
      <?php $this->load->view('branch/includes/footer.php'); ?>
      
    </div>
  </body>
  <?php $this->load->view('branch/includes/scripts.php'); ?>
  <?php $this->load->view('branch/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
  <script>
      function approve(c_id)
    	{
    		$('#disable_id').val(c_id);
    		$('#approve-order').modal('show');
    	}
    	function reject(c_id)
    	{
    		$('#enable_id').val(c_id);
    		$('#reject-order').modal('show');
    	}
    
  </script>
</html>
