<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('branch/includes/includes.php'); ?>
    <?php $this->load->view('branch/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('branch/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">Order Details</h4>
                  
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="user_data" class="table">
                    <tbody>
                       <tr>
                        <td>Order Number</td>
                        <td>ORD<?=$order->order_id?></td>
                      </tr>
                      <tr>
                        <td>Restaurant Name</td>
                        <td><?=$order->rest?></td>
                      </tr>
                      <tr>
                        <td>Customer Details</td>
                        <td><?=$order->username?><br>
                            <?=$order->useremail?><br>
                            <?=$order->userphone?>
                        </td>
                      </tr>
                      <tr>
                        <td>Address</td>
                        <td> 
                          <?=$order->area?><br>
                          <?=$order->block?>, <?=$order->road_no?>, <?=$order->building?>, <?=$order->flat?>, <?=$order->flat?><br>
                          <?=$order->mobile?>
                        </td>
                      </tr>
                      <tr>
                        <td>Ordered On</td>
                        <td>
                          <?php echo date('d M Y',strtotime($order->ordered_date)); ?><br>
                          <?=$order->ordered_time?>
                        </td>
                      </tr>
                      
                    </tbody>
                  </table>


                  <table class="table">
                   <thead>
                       <th>Product Name</th>
                       <th>Price(BHD)</th>
                       <th>Quantity</th>
                       <th>Total Price(BHD)</th>
                   </thead>
                   
                   <tbody>
                       <?php 
                       
                       foreach($order->products as $pro)
                       {
                       ?>
                       <tr>
                         <td><?=$pro->product_name?></td>
                         <td><?=$pro->price?></td>
                         <td><?=$pro->quantity?></td>
                         <td><?=$pro->total?></td>               
                       </tr>
                       <?php if($extra_check->num_rows()>0) 
                        {?>
                        <br> Extras <br>
                        <?php foreach($pro->extras as $extra) { ?>  
                             <tr>
                               <td><?=$extra->cat_name?></td>
                               <td>BHD <?=number_format($extra->price,'3')?></td>
                               <td><?=$extra->quantity?></td>
                               <td>BHD <?=number_format($extra->total,'3')?></td>               
                             </tr>
                        <?php };?>           
                      <?php } };?>  
                   </tbody>
                   
                    <tfoot>
                        <tr>
                          <td colspan="3" style="text-align:right"><b>Sub Total:</b></td><td><b> BHD <?=  number_format($order->subtotal,'3')?></b></td>
                        </tr>
                        <tr>
                          <td colspan="3" style="text-align:right"><b>Delivery Charge:</b></td><td><b> BHD <?= number_format($order->delivery_charge,'3');?></b></td>
                        </tr>
                        <tr>
                          <td colspan="3" style="text-align:right"><b>Grand Total:</b></td><td><b> BHD <?=  number_format($order->total,'3');?></b></td>
                        </tr>
                      
                  </tfoot>
                 </table>

                </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('branch/includes/footer.php'); ?>

    </div>
  </body>
  <?php $this->load->view('branch/includes/scripts.php'); ?>
  <?php $this->load->view('branch/includes/table-script.php'); ?>
 
</html>
