<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('branch/includes/includes.php'); ?>
    <?php $this->load->view('branch/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('branch/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">Approved Orders</h4>
                  
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th width="10%">Order No.</th>
                            <th width="15%">Customer Details</th>
                            <th width="15%">Ordered On</th>
                            <th width="25%">Delivery Address</th>
                            <th width="10%">Price(BHD)</th>
                            <!--<th width="10%">Order Status</th>-->
                            <th width="10%">Assign Driver</th>
                            <th width="5%">Details</th>
                        </tr>
                    </thead>
                    <tbody>
                            <?php foreach($orders as $order) {?>
                              <tr>
                                <td>ORD<?=$order->order_id?></td>
                                <td><?=$order->username?><br>
                                    <?=$order->useremail?><br>
                                    <?=$order->userphone?>
                                </td>
                                <td><?php echo date('d M Y',strtotime($order->ordered_date));?><br><?=$order->ordered_time?></td>
                                <td>
                                  <?=$order->area?><br>
                                  <?=$order->block?>, <?=$order->road_no?>, <?=$order->building?>, <?=$order->floor?>, <?=$order->flat?><br>
                                  <?=$order->mobile?>
                                </td>
                                <td>BHD <?=number_format($order->total,'3')?></td>
                                <!--<td>Order Placed</td>-->
                                <td><button type="button" class="btn btn-primary" style="font-size:12px;" onclick="add('<?=$order->order_id?>')">Assign</button></a></td>
                                <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:13px;" href="<?=site_url('branch/orders/details/'.$order->order_id)?>" >View</a></td>
                              </tr>
                            <?php };?>
                       
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
          
         <div class="modal fade" id="add-driver" tabindex="-1" role="dialog" aria-labelledby="modal-5">
            <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header bg-primary">
                  <h4 class="modal-title has-icon text-white">ADD DRIVER</h4>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                  <form class="form-horizontal" action="<?=site_url('branch/orders/assignDriver')?>" method="post" id="add-form" enctype="multipart/form-data">
                     <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">Drivers<span style="color: red; ">*</span></label>
                             <input type="hidden" name="order_id" id="order_id">
                             <select class="form-control" name="driver_id" required>
                                 <option value="">---Select Driver---</option>
                                 <?php foreach($drivers as $driver) {?>
                                   <option value="<?=$driver->dr_id?>"><?=$driver->name?> - <?=$driver->phone?></option>
                                 <?php };?>
                             </select>
                         </div>
                     </div>
                   </div>
                   <div class="modal-footer">
                     <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit" id="submit-button">Add</button>
                   </div>
                  </form>
              </div>
            </div>
          </div>
          
        </div>
      </div>
      <?php $this->load->view('branch/includes/footer.php'); ?>
      
    </div>
  </body>
  <?php $this->load->view('branch/includes/scripts.php'); ?>
  <?php $this->load->view('branch/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
  <script type="">
     function add(id)
      {
        $('#order_id').val(id);
        $('#add-driver').modal('show');
      }
    </script> 
</html>
