<!DOCTYPE html>
<html>
    <head>
      <?php $this->load->view('branch/includes/includes'); ?>
    </head>
    <body>

        <div id="wrapper">

            <?php $this->load->view('branch/includes/sidebar'); ?>

            <div class="content-page">
                <!-- Start content -->
                <div class="content">
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
                                    <h4 class="page-title float-left">DASHBOARD</h4>

                                    <ol class="breadcrumb float-right">
                                        <li class="breadcrumb-item"><a href="#">Sigofood</a></li>
                                        <li class="breadcrumb-item active">Dashboard</li>
                                    </ol>

                                    <div class="clearfix"></div>
                                </div>
                            </div>
                        </div>
                        <!-- end row -->

                        <div class="row">
                            <div class="col-xs-12 col-md-6 col-lg-6 col-xl-3">
                                <a href="<?=site_url('branch/orders/new')?>"><div class="card-box tilebox-one">
                                    <i class="fa fa-shopping-cart float-right"></i>
                                    <h6 class="text-muted text-uppercase mb-3">Today's Orders</h6>
                                    <h4 class="mb-3"><?=$order?></h4>
                                </div></a>
                            </div>
                            
                            <div class="col-xs-12 col-md-6 col-lg-6 col-xl-4">
                                <a href="<?=site_url('branch/orders/cancelled')?>"><div class="card-box tilebox-one">
                                    <i class="fa fa-shopping-cart float-right"></i>
                                    <h6 class="text-muted text-uppercase mb-3">Today's Cancelled Orders</h6>
                                    <h4 class="mb-3"><?=$cancelled_today?></h4>
                                </div></a>
                            </div>

                            <div class="col-xs-12 col-md-6 col-lg-6 col-xl-3">
                                <a href="<?=site_url('branch/products/index')?>"><div class="card-box tilebox-one">
                                    <i class="fa fa-tag float-right"></i>
                                    <h6 class="text-muted text-uppercase mb-3">Total Products</h6>
                                    <h4 class="mb-3"><?=$product?></h4>
                                </div></a>
                            </div>

                            <!--<div class="col-xs-12 col-md-6 col-lg-6 col-xl-3">-->
                            <!--    <a href="#"><div class="card-box tilebox-one">-->
                            <!--        <i class="fa fa-sliders float-right"></i>-->
                            <!--        <h6 class="text-muted text-uppercase mb-3">Total Categories</h6>-->
                            <!--        <h4 class="mb-3"><?=$category?></h4>-->
                            <!--    </div></a>-->
                            <!--</div>-->

                            <!--<div class="col-xs-12 col-md-6 col-lg-6 col-xl-3">-->
                            <!--    <a href="#"><div class="card-box tilebox-one">-->
                            <!--        <i class="fa fa-cutlery float-right"></i>-->
                            <!--        <h6 class="text-muted text-uppercase mb-3">Total Cuisines</h6>-->
                            <!--        <h4 class="mb-3"><?=$cuisine?></h4>-->
                            <!--    </div></a>-->
                            <!--</div>-->
                        </div>

                        <div class="row">
                            <div class="col-lg-5">
                                <div class="card-box">
                                    <h4 class="header-title mb-4">New Products</h4>
                                    <div class="inbox-widget slimscroll" style="max-height: 670px;">
                                      <?php foreach ($products as $pr) { ?>
                                        <a href="<?=site_url('branch/products')?>">
                                            <div class="inbox-item">
                                                <div class="inbox-item-img"><img src="<?=base_url() . $pr->cover_image?>" class="rounded-circle bx-shadow-lg" alt=""></div>
                                                <p class="inbox-item-author"><?=$pr->name?></p>
                                                <?php foreach($pr->prices as $price) {?><span class="pull-right text-success tran-price"><?=number_format($price->price,'3')?> BHD</span> <br><?php };?>
                                            </div>
                                        </a>
                                     <?php } ?>
                                    </div>
                                </div>
                            </div>

                            <!--<div class="col-lg-4">-->
                            <!--    <div class="card-box">-->
                            <!--        <h4 class="header-title mb-4">New Categories</h4>-->
                            <!--        <div class="inbox-widget slimscroll" style="max-height: 670px;">-->
                            <!--          <?php foreach ($categories as $cat) { ?>-->
                            <!--            <a href="<?=site_url('branch/categories')?>">-->
                            <!--                <div class="inbox-item">-->
                            <!--                    <p class="inbox-item-author"><?=$cat->name?></p>-->
                            <!--                </div>-->
                            <!--            </a>-->
                            <!--         <?php } ?>-->
                            <!--        </div>-->
                            <!--    </div>-->
                            <!--</div>-->

                            <div class="col-lg-5">
                                <div class="card-box">
                                    <h4 class="header-title mb-4">New Orders</h4>
                                    <?php if(count($orders)>0) {?>
                                        <div class="inbox-widget slimscroll" style="max-height: 670px;">
                                          <?php foreach ($orders as $order) { ?>
                                            <a href="<?=site_url('branch/orders/new')?>">
                                                <div class="inbox-item">
                                                    <p class="inbox-item-author">Order ID: ORD<?=$order->order_id?></p>
                                                    <p class="inbox-item-author">User: <?=$order->username?></p>
                                                    <p class="inbox-item-text">Ordered On: <?php echo date('d M Y',strtotime($order->ordered_date));?>, <?php echo $order->ordered_time;?></p>
                                                    <p class="inbox-item-text">Status: <?php if($order->status=='pending') { echo 'Pending';} 
                                                                                         elseif($order->status=='processing') { echo 'Processing';} 
                                                                                         elseif($order->status=='delivered') { echo 'Delivered';} 
                                                                                         elseif($order->status=='cancelled') { echo 'Cancelled';}
                                                                                         elseif($order->status=='approved') { echo 'Approved';}
                                                                                         elseif($order->status=='dispatched') { echo 'Dispatched';}?></p>
                                                </div>
                                            </a>
                                          <?php } ?> 
                                        </div>
                                     <?php } else { ?>
                                         You have no orders
                                     <?php };?>           
                                </div>
                            </div> 

                        </div>

                    </div>
                </div>
                <?php $this->load->view('branch/includes/footer') ?>
            </div>
        </div>
        <?php $this->load->view('branch/includes/scripts'); ?>
    </body>
</html>
