<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('admin/includes/includes.php'); ?>
    <?php $this->load->view('admin/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('admin/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">SETTINGS</h4>
                 
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                        <th>Maintenance(Driver)</th>
                        <th>Android version(Driver)</th>
                        <th>play store update(driver)</th>
                        <th>Maintenance IOS(Customer)</th>
                        <th>Maintenance Android(Customer)</th>
                        <th>Android version(Customer)</th>
                        <th>IOS version(Customer)</th>
                        <th>play store update(Customer)</th>
                        <th>App store update(Customer)</th>
                        <th>Edit</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach($settings as $setting){?>
                        <tr>
                        <?php 
                             if ($setting->maintenance_driver==0) 
                                {
                                  $maintenance_driver = "No";
                                }
                                else 
                                {
                                  $maintenance_driver = "Yes";
                                }
                                if ($setting->play_store_update_driver==0) 
                                {
                                  $play_store_update_driver = "No";
                                }
                                else 
                                {
                                  $play_store_update_driver = "Yes";
                                }
                                if ($setting->maintenance_ios_customer==0) 
                                {
                                  $maintenance_ios_customer = "No";
                                }
                                else 
                                {
                                  $maintenance_ios_customer = "Yes";
                                }
                                if ($setting->maintenance_android_customer==0) 
                                {
                                  $maintenance_android_customer = "No";
                                }
                                else 
                                {
                                  $maintenance_android_customer = "Yes";
                                }
                                if ($setting->play_store_update_customer==0) 
                                {
                                  $play_store_update_customer = "No";
                                }
                                else 
                                {
                                  $play_store_update_customer = "Yes";
                                }
                                if ($setting->app_store_update_customer==0) 
                                {
                                  $app_store_update_customer = "No";
                                }
                                else 
                                {
                                  $app_store_update_customer = "Yes";
                                }
                            ?>
                            
                            <td><?=$maintenance_driver?></td>
                            <td><?=$setting->android_version_driver?></td>
                            <td><?=$play_store_update_driver?></td>
                            <td><?=$maintenance_ios_customer?></td>
                            <td><?=$maintenance_android_customer?></td>
                            <td><?=$setting->android_version_customer?></td>
                            <td><?=$setting->ios_version_customer?></td>
                            <td><?=$play_store_update_customer?></td>
                            <td><?=$app_store_update_customer?></td>

                          
                            <td><button class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:13px;" onclick="edit()">Edit</button></td>
                        </tr>
                      <?php };?>  
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('admin/includes/footer.php'); ?>
      
        
        
          </div>

          <div class="modal fade" id="edit-style" tabindex="-1" role="dialog" aria-labelledby="modal-5">
            <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header bg-primary">
                  <h4 class="modal-title has-icon text-white">EDIT SETTINGS</h4>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                  <form class="form-horizontal" action="<?=site_url('admin/settings/editData')?>" method="post" id="edit-form">
                      <div class="form-group m-b-25">
                          <div class="col-12">
                             <label for="select">Maintenance Mode(Driver)<span style="color: red;">*</span></label>
                                <select class="form-control" name="maintenance_driver" id="maintenance_driver" required>
                                <option value="<?=$maintenance_driver?>" <?php if($maintenance_driver) {?> selected <?php };?>></option>
                                <option value="0"> No</option>
                                <option value="1"> Yes </option>
                                </select>  
                          </div>
                      </div>
                      <div class="form-group m-b-25">
                        <div class="col-12">
                           <label for="select">Android Version(Driver) </label>
                           <input type="text" minlength="3" class="form-control" name="android_version_driver" id="android_version_driver" required>
                        </div>
                     </div>
                     <div class="form-group m-b-25">
                          <div class="col-12">
                             <label for="select">Play store update(Driver)<span style="color: red;">*</span></label>
                                <select class="form-control" name="play_store_update_driver" id="play_store_update_driver" required>
                                <option value="<?=$play_store_update_driver?>" <?php if($play_store_update_driver) {?> selected <?php };?>></option>
                                    <option value="0"> No</option>
                                    <option value="1"> Yes </option>
                                </select>  
                          </div>

                          <div class="form-group m-b-25">
                          <div class="col-12">
                             <label for="select">Maintenance Mode(Android - Customer)<span style="color: red;">*</span></label>
                                <select class="form-control" name="maintenance_android_customer" id="maintenance_android_customer" required>
                                <option value="<?=$maintenance_android_customer?>" <?php if($maintenance_android_customer) {?> selected <?php };?>></option>
                                  <option value="0"> No</option>
                                  <option value="1"> Yes </option>
                                </select>  
                          </div>
                          <div class="form-group m-b-25">
                          <div class="col-12">
                             <label for="select">Maintenance Mode(IOS - Customer)<span style="color: red;">*</span></label>
                                <select class="form-control" name="maintenance_ios_customer" id="maintenance_ios_customer" required>
                                <option value="<?=$maintenance_ios_customer?>" <?php if($maintenance_ios_customer) {?> selected <?php };?>></option>
                                    <option value="0"> No</option>
                                    <option value="1"> Yes </option>
                                </select>  
                          </div>
                              </div>
                          <div class="form-group m-b-25">
                        <div class="col-12">
                           <label for="select">Android Version(Customer) </label>
                           <input type="text" minlength="3" class="form-control" name="android_version_customer" id="android_version_customer" required>
                        </div>
                     </div>

                     <div class="form-group m-b-25">
                        <div class="col-12">
                           <label for="select">IOS Version(Customer) </label>
                           <input type="text" minlength="3" class="form-control" name="ios_version_customer" id="ios_version_customer" required>
                        </div>
                     </div>

                     <div class="form-group m-b-25">
                          <div class="col-12">
                             <label for="select">Play store update(Customer)<span style="color: red;">*</span></label>
                                <select class="form-control" name="play_store_update_customer" id="play_store_update_customer" required>
                                <option value="<?=$play_store_update_customer?>" <?php if($play_store_update_customer) {?> selected <?php };?>></option>
                                  <option value="0"> No</option>
                                    <option value="1"> Yes </option>
                                </select>  
                          </div>


                          <div class="form-group m-b-25">
                          <div class="col-12">
                             <label for="select">App store update(Customer)<span style="color: red;">*</span></label>
                             <select class="form-control" name="app_store_update_customer" id="app_store_update_customer" required>
                             <option value="<?=$app_store_update_customer?>" <?php if($app_store_update_customer) {?> selected <?php };?>></option>
                                    <option value="0"> No</option>
                                    <option value="1"> Yes </option>
                                </select>  
                          </div>
                   
                   <div class="modal-footer">
                      <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                      <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit" id="submit">Update</button>
                   </div>
                  </form>
                </div>
            </div>
          </div>

      
        
     

    </div>
  </body>
  <?php $this->load->view('admin/includes/scripts.php'); ?>
  <?php $this->load->view('admin/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
  <script type="">
     function add()
      {
        $('#add-style').modal('show');
      }

      function edit()
      {
        
        $.ajax({
          method: "POST",
          url: "<?=site_url('admin/settings/getDetails');?>",
        //   data : { id : id },
          dataType : "json",
          success : function(data)
          {
            var settings    = data.setting;
            // alert(data.setting.android_version_driver);
            $('#maintenance_driver').val(settings.maintenance_driver);
            $('#android_version_driver').val(settings.android_version_driver);
            $('#play_store_update_driver').val(settings.play_store_update_driver);
            $('#maintenance_android_customer').val(settings.maintenance_android_customer);
            $('#maintenance_ios_customer').val(settings.maintenance_ios_customer);
            $('#android_version_customer').val(settings.android_version_customer);
            $('#ios_version_customer').val(settings.ios_version_customer);
            $('#play_store_update_customer').val(settings.play_store_update_customer);
            $('#app_store_update_customer').val(settings.app_store_update_customer);
            $('#edit-style').modal('show');
          }
        });
      }
  </script>
  <script>
      function disable(c_id)
    	{
    		$('#disable_id').val(c_id);
    		$('#disable-place').modal('show');
    	}
    	function enable(c_id)
    	{
    		$('#enable_id').val(c_id);
    		$('#enable-place').modal('show');
    	}
    
  </script>
</html>
