<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('admin/includes/includes.php'); ?>
    <?php $this->load->view('admin/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('admin/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">RESTAURANTS</h4>
                 
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="user_data" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                        <th width="5%">Restaurant Image</th>
                        <th width="25%">Restaurant Name</th>
                        <th width="10%">Restaurant Code</th>
                        <th width="15%">Restaurant Open/Close Time</th>
                        <!-- <th width="15%">Restaurant Open Control</th> -->
                        <th width="15%">Email</th>
                        <th width="15%">Phone</th>
                        <!-- <th width="15%">Location</th> -->
                        <th width="10%">Status</th>
                        <th width="10%">Change Password</th>
                        <th width="5%">Edit</th>
                        <th width="5%">Details</th>
                      </tr>
                    </thead>
                  </table>
                </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="disable-restaurant" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DISABLE RESTAURANT</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to disable this restaurant?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('admin/restaurants/disable')?>" method="post">
                      <input type="hidden" name="r_id" id="r_disable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Disable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="enable-restaurant" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ENABLE RESTAURANT</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to enable this restaurant?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('admin/restaurants/enable')?>" method="post">
                      <input type="hidden" name="r_id" id="r_enable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Enable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div id="change_password" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="custom-width-modalLabel" aria-hidden="true" style="display: none;">
              <div class="modal-dialog">
                  <div class="modal-content">

                      <div class="modal-body">
                          <h2 class="text-uppercase text-center m-b-30">
                            <span><h4>Change password</h4></span>
                          </h2>
                          <form id="form-password" class="form-horizontal" action="<?=site_url('admin/restaurants/changePassword')?>" method="post">
                              
                              <div class="form-group m-b-25">
                                  <div class="col-12">
                                      <label for="select">New Password</label>
                                      <input type="password" name="password" id="pass1" class="form-control" minlength="6" maxlength="16" required>
                                  </div>
                              </div>
                              <input type="hidden" name="rest_id" id="rest_id">
                              <div class="form-group m-b-25">
                                  <div class="col-12">
                                      <label for="select">Confirm Password</label>
                                      <input type="password"  id="pass2" class="form-control" minlength="6" maxlength="16" required>
                                  </div>
                              </div>
                              <div class="" style="text-align:center;color:red;padding-bottom:10px;" id="message">
                              </div>
                              <div class="form-group account-btn text-center m-t-10">
                                  <div class="col-12">
                                      <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                                      <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Change</button>
                                  </div>
                              </div>
                          </form>
                        </div>
                    </div><!-- /.modal-content -->
                </div><!-- /.modal-dialog -->
            </div>
        
      </div>
      <?php $this->load->view('admin/includes/footer.php'); ?>
    </div>
  </body>
  <?php $this->load->view('admin/includes/scripts.php'); ?>
  <?php $this->load->view('admin/includes/table-script.php'); ?>
  <script type="text/javascript">
    $(document).ready(function(){
      var dataTable = $('#user_data').DataTable({
        "processing":true,
        "serverSide":true,
        "order":[],
        "ajax":{
          url:"<?=site_url('admin/restaurants/get')?>",
          type:"POST"
        },
        "columnDefs":[
          {
            "target":[0,3,4],
            "orderable":true
          }
        ]
      });
    });
  </script>
  <script>
      function disable(r_id)
    	{
    		$('#r_disable_id').val(r_id);
    		$('#disable-restaurant').modal('show');
    	}
    	function enable(r_id)
    	{
    		$('#r_enable_id').val(r_id);
    		$('#enable-restaurant').modal('show');
    	}
        function change_password(key)
        {
          $('#rest_id').val(key);
          $('#change_password').modal('show');
        }
  </script>
  <script type="">
    $('#form-password').on('submit', function(e){
       e.preventDefault();
      // CODE HERE
      id          = $('#rest_id').val();
      password   = $('#pass_old').val();
    
      var pass1 = $('#pass1').val();
      var length = pass1.length;
      if (length < 6) 
      {
        toastr.error("Password should contain atleast 6 characters..!");
        return false;
      }
      else 
      {
        var pass2 = $('#pass2').val();
        if (pass1 == pass2) 
        {
          document.getElementById("form-password").submit();
          return true;
        }
        else 
        {
          toastr.error("Password mismatch"); 
          return false;
        }
      }         
    });
  </script>
</html>
