<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('admin/includes/includes.php'); ?>
    <link rel="stylesheet" href="<?=base_url()?>plugins/image-crop/croppie.css">
    <link href="<?=base_url()?>plugins/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet">
    <link href="<?=base_url()?>plugins/clockpicker/css/bootstrap-clockpicker.min.css" rel="stylesheet">
    <style type="text/css">
      .bootstrap-datetimepicker-widget tr:hover {
       background-color: #808080;
     }
    </style>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('admin/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">Restaurant Details</h4>
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
              <div class="card-box">
                  <div class="row">
                    
                    <div class="col-xl-7 col-md-12">
                      <div class="ms-panel ms-panel-fh">
                        <div class="ms-panel-body">
                          <table class="table ms-profile-information">
                            <tbody>
                              <tr>
                                <th scope="row">Restaurant Name</th>
                                <td><?=$rest->rest_name?></td>
                              </tr>
                              <tr>
                                <th scope="row">Restaurant Code</th>
                                <td><?=$rest->rest_code?></td>
                              </tr>
                              <tr>
                                <th scope="row">Email Address</th>
                                <td><?=$rest->rest_email?></td>
                              </tr>
                              <tr>
                                <th scope="row">Phone Number</th>
                                <td><?=$rest->rest_phone?></td>
                              </tr>
                              <tr>
                                <th scope="row">Open Time</th>
                                <td><?php echo date('h:i A',strtotime($rest->open_time));?></td>
                              </tr>
                              <tr>
                                <th scope="row">Close Time</th>
                                <td><?php echo date('h:i A',strtotime($rest->close_time));?></td>
                              </tr>
                              <tr>
                                <th scope="row">Location</th>
                                <td><?=$rest->landmark?></td>
                              </tr>
                              <tr>
                                <th scope="row">City</th>
                                <td><?=$rest->city?></td>
                              </tr>
                              <tr>
                                <th scope="row">Delivery Charge</th>
                                <td>BHD <?=number_format($rest->delivery_charge,'3')?></td>
                              </tr>
                              <tr>
                                <th scope="row">Minimum Orders</th>
                                <td>BHD <?=number_format($rest->min_order,'3')?></td>
                              </tr>
                              <tr>
                                <th scope="row">Url</th>
                                <!-- <td><a href="https://www.cpos.co/users/restaurant">sigofood/users/restaurant/login/</a></td> -->
                                <td><a href="https://ourworks.co.in/sigofood/users/restaurant">sigofood/users/restaurant/login/</a></td>

                              </tr>
                              <tr>
                                <th scope="row">Password</th>
                                <td><?=$rest->password?></td>
                              </tr>
                            </tbody>
                          </table>
                          <label><b><u>Restaurant Image</u></b></label>
                          <img src="<?=base_url() . $rest->rest_image?>" width="100%">
                        </div>
                      </div>
                    </div>
                    
                    <div class="col-xl-5 col-md-12">
                      <div class="ms-panel ms-panel-fh">
                        <div class="ms-panel-body">
                          <h5 class="section-title">Address</h2>
                          <p>
                            <?=$rest->address1?><br>
                          </p>
            
                          <div class="ms-profile-skills">
                            <h5 class="section-title">Cuisines</h5>
                            <?php if(count($types)==0) {?>
                             <i>No Cuisines</i> <br>
                             <?php } else { ?>
                            <ul class="ms-skill-list">
                             <?php foreach($types as $type) {?>  
                              <li class="ms-skill"><?=$type->name?></li>
                            <?php } };?>
                            </ul>
                           
                            <br>
                            <label><b><u>Cover Image</u></b></label>
                            <img src="<?=base_url() . $rest->cover_image?>" width="100%">
                            <br><br>
                            <!--<label><b><u>Thumbnail</u></b></label>-->
                            <!--<img src="<?=base_url() . $rest->thumbnail?>" width="100%">-->
                          </div> 
                          
                        </div>    
                      </div>
                    </div>
                    
                  </div>
                </div>

              </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('admin/includes/footer.php'); ?>
    </div>
  </body>
  <?php $this->load->view('admin/includes/scripts.php'); ?>
  <script src="<?=base_url()?>plugins/image-crop/croppie.js"></script>
  <script src="<?=base_url()?>plugins/bootstrap-timepicker/bootstrap-timepicker.js"></script>
  <script src="<?=base_url()?>assets/pages/jquery.form-pickers.init.js"></script>
</html>
