<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('admin/includes/includes.php'); ?>
    <?php $this->load->view('admin/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('admin/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">Completed Orders</h4>
                  
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                          <th width="10%">Order No.</th>
                          <th width="15%">Restaurant Name</th>
                          <th width="15%">Customer Name</th>
                          <th width="15%">Booking date & time</th>
                          <th width="25%">Delivery Address</th>
                          <th width="10%">Price</th>
                          <th width="10%">Order Status</th>
                          <th width="5%">Details</th>
                      </tr>
                   </thead>
                   <tbody>
                       <?php foreach($orders as $order) {?>
                              <tr>
                                <td>ORD<?=$order->order_id?></td>
                                <td><?=$order->rest?></td>
                                <td><?=$order->username?><br>
                                    <?=$order->useremail?><br>
                                    <?=$order->userphone?>
                                </td>
                                <td><?php echo date('d-M-Y',strtotime($order->ordered_date));?><br><?=$order->ordered_time?></td>
                                <td>
                                  <?=$order->floor?><br>
                                  <?=$order->building?><br>
                                  <?=$order->street?><br>
                                  <?=$order->area?>
                                </td>
                                <td><?=number_format($order->total,'2')?> BD</td>
                                <td>Order Delivered successfully</td>
                                <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:13px;" href="#" >View</a></td>
                              </tr>
                            <?php };?>
                        </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('admin/includes/footer.php'); ?>
      
    </div>
  </body>
  <?php $this->load->view('admin/includes/scripts.php'); ?>
  <?php $this->load->view('admin/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
  
</html>
