<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('admin/includes/includes.php'); ?>
    <?php $this->load->view('admin/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('admin/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">Order Details</h4>
                  <div class="form-row">
                        <div class="col-md-12 mt-4">
                            <a class="btn btn-success waves-light waves-effect w-md pull-right" href="javascript:window.history.go(-1);">Back</a>
                        </div>
                      </div>
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="user_data" class="table">
                    <tbody>
                      <tr>
                        <td>Order Number</td>
                        <td>ORD<?=$order->order_id?></td>
                      </tr>
                      <tr>
                        <td>Restaurant Name</td>
                        <td><?=$order->rest?></td>
                      </tr>
                      <!--<tr>-->
                      <!--  <td>User Type</td>-->
                      <!--  <td><?php if($order->type=='guest') {?> Guest<?php } else {?> User<?php };?> </td>-->
                      <!--</tr>-->
                      <tr>
                        <td>Customer Details</td>
                        <td><?=$order->username?><br>
                            <?=$order->useremail?><br>
                            <?=$order->userphone?>
                        </td>
                      </tr>
                      <tr>
                        <td>Address</td>
                        <td> 
                          <?=$order->area?><br>
                          <?=$order->block?>, <?=$order->road_no?>, <?=$order->building?>, <?=$order->landmark?>, <?=$order->flat?><br>
                          Mobile no: +973 <?=$order->mobile?>
                        </td>
                      </tr>
                      <tr>
                        <td>Ordered On</td>
                        <td>
                          <?php echo date('d M Y',strtotime($order->ordered_date)); ?><br>
                          <?=$order->ordered_time?>
                        </td>
                      </tr>
                      <?php if($order->status=='delivered') { ?>
                      <tr>
                        <td>Completed On</td>
                        <td>
                          <?php echo date('d M Y',strtotime($order->completed_date)); ?><br>
                          <?=$order->completed_time?>
                        </td>
                      </tr>
                      <?php };?>
                      <?php if($order->order_type=='scheduled') { ?>
                      <tr>
                        <td>Scheduled On</td>
                        <td>
                          <?php echo date('d M Y',strtotime($order->delivery_date)); ?><br>
                          <?=$order->delivery_time?>
                        </td>
                      </tr>
                      <?php };?>
                      <tr>
                        <td>Order Status</td>
                        <td>
                          <?php if($order->status=='pending') { ?>
                            Pending
                          <?php } elseif($order->status=='processing') { ?>  
                           Processing
                          <?php } elseif($order->status=='cancelled') { ?>  
                           Cancelled
                          <?php } elseif($order->status=='delivered') { ?> 
                           Delivered
                          <?php } elseif($order->status=='approved') { ?>  
                           Approved
                          <?php } elseif($order->status=='dispatched') { ?> 
                           Dispatched
                           <?php }; ?>  
                        </td>
                      </tr>
                      <?php if($order->offer_type=='promotion') {?>
                         <tr>
                           <td>Offer Type</td>
                           <td>Promotion</td>
                         </tr>
                      <?php } elseif($order->offer_type=='offer') {?>
                        <tr>
                           <td>Offer Type</td>
                           <td>Offer</td>
                         </tr>
                      <?php };?>
                    </tbody>
                  </table>


                  <table class="table">
                   <thead>
                       <th>Sl.No</th>
                       <th>Product Name</th>
                       <th>Price(BHD)</th>
                       <th>Quantity</th>
                       <th>Total Price(BHD)</th>
                   </thead>
                   
                   <tbody>
                       <?php $i=1;
                       foreach($order->products as $product)
                       {
                       ?>
                       <tr>
                         <td><?=$i?></td>
                         <td><?=$product->product_name?></td>
                         <td>BHD <?=number_format($product->price,'3')?> </td>
                         <td><?=$product->quantity?></td>
                         <td>BHD <?=number_format($product->total,'3')?> </td>               
                       </tr>
                       <?php if($extra_check->num_rows()>0) 
                        {?>
                        <?php $j='a'; foreach($product->extras as $extra) { ?>  
                             <tr>
                               <td><?=$i?>.<?=$j?></td>
                               <td><?=$extra->cat_value?></td>
                               <td>BHD <?=number_format($extra->price,'3')?> </td>
                               <td><?=$extra->quantity?></td>
                               <td>BHD <?=number_format($extra->total,'3')?> </td>               
                             </tr>
                        <?php $j++; };?>           
                      <?php } $i++; };?>  
                   </tbody>
                   
                    <tfoot>
                        <tr>
                          <td colspan="4" style="text-align:right">Sub Total:</td><td>BHD <?php echo number_format($order->subtotal,'3');?></td>
                        </tr>
                       
                        <tr>
                          <td colspan="4" style="text-align:right">Delivery Charge:</td><td>BHD <?php echo number_format($order->delivery_charge,'3');?> </td>
                        </tr>
                        <tr>
                          <td colspan="4" style="text-align:right"><b>Grand Total:</b></td><td><b>BHD <?php echo number_format($order->total,'3');?></b></td>
                        </tr>
                    </tfoot>
                 </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('admin/includes/footer.php'); ?>

    </div>
  </body>
  <?php $this->load->view('admin/includes/scripts.php'); ?>
  <?php $this->load->view('admin/includes/table-script.php'); ?>
 
</html>
