<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('admin/includes/includes.php'); ?>
    <?php $this->load->view('admin/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('admin/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">PROMOTIONS</h4>
                  
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                          <th width="10%">Promotion Image</th>
                          <th width="15%">Restaurant Name</th>
                          <th width="20%">Promotion Title</th>
                          <th width="30%">Description</th>
                          <th width="10%">Price(BHD)</th>
                          <th width="5%">Status</th>
                      </tr>
                   </thead>
                   <tbody>
                    <?php foreach($promotions as $pro){?>
                      <tr>
                      
                          <td>
                            <?php if($pro->image!='') {?>
                              <img src="<?=base_url().$pro->image;?>" width="100%">
                            <?php } else {?>
                              <img src="<?=base_url()?>uploads/restaurant/promotion/default.svg" width="100%">  
                            <?php };?>
                          </td>
                          <td><?=$pro->restaurant?></td>
                          <td><?=$pro->title?></td>
                          <td><?=$pro->description?></td>
                          <td>BHD <?=number_format($pro->price,'3')?> </td>
                          <td>
                              <?php if ($pro->status=='active') 
                                  {
                                    $status = "Active";
                                    $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$pro->pr_id.')"  >Disable</a>';
                                  }
                                  elseif($pro->status=='blocked') 
                                  {
                                    $status = "Blocked";
                                    $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$pro->pr_id.')" >Enable</a>';
                                  }
                                  else
                                  {
                                    $status = "Requested";
                                    $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="accept('.$pro->pr_id.')" >Accept</a>';
                                  }
                                  echo $status.'<br>'.$action;
                              ?>
                          </td>
                      </tr>
                    <?php };?>  
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="disable-promotion" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DISABLE PROMOTION</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to disable this promotion?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('admin/offers/disable_promotion')?>" method="post">
                      <input type="hidden" name="promotion_id" id="disable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Disable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="enable-promotion" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ENABLE PROMOTION</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to enable this promotion?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('admin/offers/enable_promotion')?>" method="post">
                      <input type="hidden" name="promotion_id" id="enable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Enable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="accept-promotion" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ACCEPT PROMOTION</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to accept this promotion?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('admin/offers/accept_promotion')?>" method="post">
                      <input type="hidden" name="promotion_id" id="accept_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Accept</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
      </div>
      <?php $this->load->view('admin/includes/footer.php'); ?>
    </div>
  </body>
  <?php $this->load->view('admin/includes/scripts.php'); ?>
  <?php $this->load->view('admin/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
  <script>
      function disable(c_id)
    	{
    		$('#disable_id').val(c_id);
    		$('#disable-promotion').modal('show');
    	}
    	function enable(c_id)
    	{
    		$('#enable_id').val(c_id);
    		$('#enable-promotion').modal('show');
    	}
        function accept(c_id)
    	{
    		$('#accept_id').val(c_id);
    		$('#accept-promotion').modal('show');
    	}
  </script>

</html>
