<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('admin/includes/includes.php'); ?>
    <?php $this->load->view('admin/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('admin/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">COUPONS</h4>
                  <ol class="breadcrumb float-right">
                    <button type="button" class="btn btn-gradient btn-rounded waves-light waves-effect w-md" onclick="add()">Add New Coupon</button>
                  </ol>
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                          <th width="10%">Coupon  Code</th>
                          <th width="15%">Coupon  Title</th>
                          <th width="15%">Restaurant Name</th>
                          <th width="10%">Offer Percentage</th>
                          <th width="15%">Minimum Cart Value</th>
                          <th width="15%">Start Date</th>
                          <th width="15%">End Date</th>
                          <th width="5%">Status</th>
                          <th width="5%">Edit</th>
                      </tr>
                   </thead>
                  <tbody>
                    <?php foreach($coupons as $coup){?>
                      <tr>
                          <?php 
                           if ($coup->status) 
                              {
                                $status = "Active";
                                $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$coup->c_id.')" >Disable</a>';
                              }
                              else 
                              {
                                $status = "Blocked";
                                $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$coup->c_id.')"  >Enable</a>';
                              }
                          ?>
                          <td><?=$coup->offer_code?></td>
                          <td><?=$coup->title?></td>
                          <td><?=$coup->restaurant?></td>
                          <td><?=$coup->percentage?> %</td>
                          <td>BHD <?=number_format($coup->max_value,'3')?> </td>
                          <td><?php echo date('d M Y',strtotime($coup->start_date));?><?php if($coup->start_time != '00:00:00') { echo ', <br>'.date('h:i A',strtotime($coup->start_time)); } ?> </td>
                          <td> <?php echo date('d M Y',strtotime($coup->end_date));?><?php if($coup->end_time != '00:00:00') { echo ', <br>'. date('h:i A',strtotime($coup->end_time)); } ?></td>
                          <td><?=$status.'<br>'.$action;?></td>
                          <td><button class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="edit('<?=$coup->c_id?>')">Edit</button></td>
                      </tr>
                    <?php };?>  
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('admin/includes/footer.php'); ?>
      
      <div class="modal fade" id="add-style" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ADD COUPON</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
              <div class="modal-body">
                <form class="form-horizontal" action="<?=site_url('admin/offers/addCoupon')?>" method="post" id="add-form">
                     <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">Restaurant<span style="color: red;">*</span></label>
                             <select class="form-control" name="rest_id" required="">
                                <option value="">---Select Restaurant---</option>
                               <?php foreach($restaurants as $rest) {?>
                                <option value="<?=$rest->r_id?>"><?=$rest->rest_name?></option>
                               <?php };?>
                             </select>
                         </div>
                      </div>
                      <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">Title<span style="color: red;">*</span></label>
                             <input type="text" class="form-control" name="title" id="title" placeholder="Title" required>
                         </div>
                      </div>
                      <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">Description</label>
                             <textarea type="text" class="form-control" name="description" id="description" placeholder="Description" ></textarea>
                         </div>
                      </div>
                      <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">Offer code<span style="color: red;">*</span></label>
                             <input type="text" class="form-control" name="code" id="code" placeholder="Offer Code" required>
                         </div>
                      </div>
                       <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">Offer Percentage<span style="color: red;">*</span></label>
                               <input type="number" step="any" min="0" class="form-control" name="percentage" placeholder="Percentage" required>
                           </div>
                       </div>
                       <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">Minimum Cart Value<span style="color: red;">*</span></label>
                               <input type="number" step="any" min="0" class="form-control" name="cart" placeholder="Minimum Cart Value" required>
                           </div>
                       </div>

                       <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">Start Date<span style="color: red;">*</span></label>
                               <input type="date" class="form-control" name="start_date" id="start" value="<?=date('Y-m-d')?>" required>
                           </div>
                       </div>

                      <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">Start time</label>
                               <input type="time" class="form-control" name="start_time" id="start_time">
                           </div>
                       </div>

                       <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">End Date<span style="color: red;">*</span></label>
                               <input type="date" class="form-control" name="end_date" id="end" value="<?=date('Y-m-d')?>" required>
                           </div>
                       </div>
                      
                       <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">End time</label>
                               <input type="time" class="form-control" name="end_time" id="end_time" >
                           </div>
                       </div>
                    </div>
                    <div class="modal-footer">
                      <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                      <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit" id="submit-button">Add</button>
                    </div>
                </form>
            </div>
          </div>
        </div>

    <div class="modal fade" id="edit-style" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">EDIT COUPON</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
              <div class="modal-body">
                <form class="form-horizontal" action="<?=site_url('admin/offers/editCoupon')?>" method="post" id="edit-form">
                      <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">Restaurant<span style="color: red;">*</span></label>
                             <select class="form-control"  name="rest_id" id="restaurant" required>                         
                             </select>
                             <input type="hidden" name="coupon_id" id="coupon_id">
                         </div>
                      </div>
                      <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">Title<span style="color: red;">*</span></label>
                             <input type="text" class="form-control" name="title" id="c_title" placeholder="Title" required>
                         </div>
                      </div>
                      <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">Description</label>
                             <textarea type="text" class="form-control" name="description" id="c_description" placeholder="Description" ></textarea>
                         </div>
                      </div>
                      <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">Offer code<span style="color: red;">*</span></label>
                             <input type="text" class="form-control" name="code" id="c_code" placeholder="Offer Code" required>
                         </div>
                      </div>
                       <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">Offer Percentage<span style="color: red;">*</span></label>
                               <input type="number" step="any" min="0" class="form-control" name="percentage" id="percentage" placeholder="Percentage" required>
                           </div>
                       </div>
                       <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">Minimum Cart Value<span style="color: red;">*</span></label>
                               <input type="number" step="any" min="0" class="form-control" name="cart" id="cart" placeholder="Minimum Cart Value" required>
                           </div>
                       </div>

                       <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">Start Date<span style="color: red;">*</span></label>
                               <input type="date" class="form-control" name="start_date" id="c_start" value="<?=date('Y-m-d')?>" required>
                           </div>
                       </div>

                      <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">Start time</label>
                               <input type="time" class="form-control" name="start_time" id="c_start_time">
                           </div>
                       </div>

                       <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">End Date<span style="color: red;">*</span></label>
                               <input type="date" class="form-control" name="end_date" id="c_end" value="<?=date('Y-m-d')?>" required>
                           </div>
                       </div>
                      
                       <div class="form-group m-b-25">
                           <div class="col-12">
                               <label for="select">End time</label>
                               <input type="time" class="form-control" name="end_time" id="c_end_time" >
                           </div>
                       </div>
                    </div>
                    <div class="modal-footer">
                      <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                      <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Update</button>
                    </div>
                </form>
            </div>
          </div>
        </div>

       <div class="modal fade" id="disable-coupon" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DISABLE COUPON</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to disable this coupon?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('admin/offers/disable_coupon')?>" method="post">
                      <input type="hidden" name="coupon_id" id="disable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Disable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="enable-coupon" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ENABLE COUPON</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to enable this coupon?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('admin/offers/enable_coupon')?>" method="post">
                      <input type="hidden" name="coupon_id" id="enable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Enable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
       
    </div>
  </body>
  <?php $this->load->view('admin/includes/scripts.php'); ?>
  <?php $this->load->view('admin/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
  <script type="">
     function add()
      {
        $('#add-style').modal('show');
      }

      function edit(id)
      {
        $('#coupon_id').val(id);
        // alert(id);
        $.ajax({
          method: "POST",
          url: "<?=site_url('admin/offers/getCouponDetails');?>",
          data : { id : id },
          dataType : "json",
          success : function(data)
          {
            var coupon    = data.coupons;
            var restaurant= data.restaurants;
            // alert(restaurant);
            $('#c_title').val(coupon.title);
            $('#c_description').val(coupon.description);
            $('#c_code').val(coupon.offer_code);
            $('#percentage').val(coupon.percentage);
            $('#cart').val(coupon.max_value);
            $('#c_start').val(coupon.start_date);
            $('#c_end').val(coupon.end_date);
            $('#c_start_time').val(coupon.start_time);
            $('#c_end_time').val(coupon.end_time);
            $('#restaurant').html(restaurant);
            $('#edit-style').modal('show');
          }
        });
      }
  </script>
  <script type="">
      $('#add-form').on('submit', function(e){
      e.preventDefault();
    
      var today = new Date().toISOString().split('T')[0];  
      var start = $('#start').val();
      var end   = $('#end').val();
      var code  = $('#code').val();  

      if ( start < today)
      {
        toastr.error("","Start date cannot be lesser than current date"); 
      }
      else if (end < start)
      {
        toastr.error("","End date cannot be lesser than start date"); 
      }
      else 
      {   
          $.ajax({
              method: "POST",
              url: "<?php echo site_url('admin/offers/checkCoupon');?>",
              dataType : "json",
              data : { code      : code
                     },
              success : function( data )
              {
                if (data == 0) 
                {
                  document.getElementById("add-form").submit();
                  return true;
                }
                else
                {
                  toastr.error("","Offer code already exists");         
                }           
              }             
            });           
      }
    });
  </script>
  <script type="">
    $('#edit-form').on('submit', function(e){
      e.preventDefault();
    
      var today  = new Date().toISOString().split('T')[0];  
      var start  = $('#c_start').val();
      var end    = $('#c_end').val();
      var code   = $('#c_code').val();
      var id     = $('#coupon_id').val();  
    
      if ( start < today)
      {
        toastr.error("","Start date cannot be lesser than current date"); 
      }
      else if (end < start)
      {
        toastr.error("","End date cannot be lesser than start date"); 
      }
      else 
      {   
        $.ajax({
            method: "POST",
            url: "<?php echo site_url('admin/offers/checkCouponById');?>",
            dataType : "json",
            data : { code      : code,
                     id        : id
                   },
            success : function( data )
            {
              if (data == 0) 
              {
                document.getElementById("edit-form").submit();
                return true;
              }
              else
              {
                toastr.error("","Offer code already exists");         
              }           
            }             
          });           
      }
    });

  </script>
  <script>
      function disable(c_id)
    	{
    		$('#disable_id').val(c_id);
    		$('#disable-coupon').modal('show');
    	}
    	function enable(c_id)
    	{
    		$('#enable_id').val(c_id);
    		$('#enable-coupon').modal('show');
    	}
    
  </script>
</html>
