<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('admin/includes/includes.php'); ?>
    <?php $this->load->view('admin/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('admin/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">Social Media</h4>
                  <!--<ol class="breadcrumb float-right">-->
                    <!--<button type="button" class="btn btn-gradient btn-rounded waves-light waves-effect w-md" onclick="add()">Add Terms</button>-->
                  <!--</ol>-->
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                        <th width="30%">Medias</th>
                        <th width="50%">Link</th>
                        <th width="10%">Edit</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach($medias as $media){?>
                        <tr>
                            <td><?=$media->media?></td>
                            <td><?=$media->link?></td>
                            <td><button class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:13px;" onclick="edit('<?=$media->sm_id?>')">Edit</button></td>
                        </tr>
                      <?php };?>  
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('admin/includes/footer.php'); ?>
      
     <div class="modal fade" id="edit-style" tabindex="-1" role="dialog" aria-labelledby="modal-5">
        <div class="modal-dialog modal-dialog-centered" role="document">
          <div class="modal-content">
            <div class="modal-header bg-primary">
              <h4 class="modal-title has-icon text-white">EDIT Link</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
              <form class="form-horizontal" action="<?=site_url('admin/media/editData')?>" method="post" id="edit-form">
                 <div class="form-group m-b-25">
                    <div class="form-group m-b-25">
                    <div class="col-12">
                       <label for="select">Name</label>
                       <input type="text" class="form-control" name="link" id="link" required>
                       <input type="hidden" name="sm_id" id="sm_id">
                    </div>

               </div>
                 </div>
               </div>
                  <div class="modal-footer">
                    <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                    <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit" id="submit">Update</button>
                  </div>
              </form>
          </div>
        </div>
      </div>
      
    </div>
  </body>
  <?php $this->load->view('admin/includes/scripts.php'); ?>
  <?php $this->load->view('admin/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
  <script type="">
     function add()
      {
        $('#add-style').modal('show');
      }

      function edit(id)
      {
        $('#sm_id').val(id);
        // alert(id);
        $.ajax({
          method: "POST",
          url: "<?=site_url('admin/media/getDetails');?>",
          data : { id : id },
          dataType : "json",
          success : function(data)
          {
            $('#link').val(data.link);
            $('#edit-style').modal('show');
          }
        });
      }
  </script>
</html>
