<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('admin/includes/includes.php'); ?>
    <link rel="stylesheet" href="<?=base_url()?>plugins/image-crop/croppie.css">

    <link href="<?=base_url()?>plugins/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet">
    <link href="<?=base_url()?>plugins/clockpicker/css/bootstrap-clockpicker.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet" />
    <style type="text/css">
      .bootstrap-datetimepicker-widget tr:hover {
       background-color: #808080;
     }
    </style>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('admin/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">EDIT</h4>
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
              <div class="card-box">
                <form  id="Myform" action="<?=site_url('admin/home_section/editData')?>" method="post" enctype="multipart/form-data">
                  <div class="form-row">
                    <div class="col-md-8">
                      <label>Title<span style="color: red;">*</span></label>
                      <div class="input-group">
                        <input type="text" name="title" class="form-control"  placeholder="Enter Title" value="<?=$section->title?>" required>
                        <input type="hidden" name="section_id" value="<?=$section->hs_id?>">
                      </div>
                    </div>                  
                    <div class="col-md-8">
                      <br>
                      <div class="input-group">
                         <label><input type='checkbox' name="type" id='type' value="<?=$section->type?>" onclick="myFunction()" <?php if($section->type=='1') {?> checked <?php };?> />&nbsp;&nbsp;&nbsp;Cuisines </label>
                      </div>
                    </div> 
                    
                    <?php if($section->type=='1') { ?>
                      <div class="col-md-8" id="cuisine-section">
                          <label>Select Cuisine<span style="color: red;">*</span></label>
                          <select class="js-example-basic-multiple" name="cuisines[]" id="cuisine" multiple="multiple">
                              <option value="">---Select Cuisine---</option>
                              <?php foreach($cuisines as $cu) {?>
                                <option value="<?=$cu->c_id?>" <?php if($cu->stat=='1') {?> selected <?php };?>><?php echo $cu->name; ?></option>
                              <?php };?>
                          </select>
                      </div>
                    <?php } else {?>  
                      <div class="col-md-8" id="cuisine-section" style="display:none;">
                          <label>Select Cuisine<span style="color: red;">*</span></label>
                          <select class="js-example-basic-multiple" name="cuisines[]" id="cuisine" multiple="multiple">
                              <option value="">---Select Cuisine---</option>
                              <?php foreach($cuisines as $cu) {?>
                                <option value="<?=$cu->c_id?>"><?php echo $cu->name; ?></option>
                              <?php };?>
                          </select>
                      </div>
                    <?php };?>  
                    
                  </div>
                  <div class="form-row">
                    <div class="col-md-12 mt-4">
                      <button type="submit" class="btn btn-success waves-light waves-effect w-md pull-right" id="submit-button" style="display:block;">Update</button>
                    </div>
                  </div>  
                </div>

                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('admin/includes/footer.php'); ?>
    </div>
  </body>
  <?php $this->load->view('admin/includes/scripts.php'); ?>
  <script src="<?=base_url()?>plugins/image-crop/croppie.js"></script>

  <script src="<?=base_url()?>plugins/bootstrap-timepicker/bootstrap-timepicker.js"></script>
  <script src="<?=base_url()?>assets/pages/jquery.form-pickers.init.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>
  <script type="">
    $(document).ready(function() {
      $('.js-example-basic-multiple').select2();
    });


      $('#category').on('change',function(){
        var cuisine  = $("#category option:selected").val();
        if(cuisine=='2')
        {
          $('#cuisine-section').css('display','block');    
        }
        else
        {
          $('#cuisine-section').css('display','none');
        }
      });

      $('#cuisine').on('change',function(){
        var cu_id  = $("#cuisine option:selected").val();
        $.ajax({
          method: "POST",
          url: "<?=site_url('admin/home_section/getRestaurants');?>",
          data : { cu_id : cu_id
                 },
          dataType : "json",
          success : function( data ){
            // alert(data);
            var opt = "<option value=''>-- Select Restaurant --</option>";
            opt = opt + data;
            $('#restaurant').html(opt);
              }
        });
      });
  </script>
   <script>
    function myFunction() {
      var checkBox = document.getElementById("type");
      if (checkBox.checked == true){
        $('#cuisine-section').css('display','block');
        document.getElementById("type").value='1';
      } else {
         $('#cuisine-section').css('display','none');
         document.getElementById("type").value='0';
      }
    }
  </script>
  <script type="">
        $('#Myform').on('submit', function(e){
         e.preventDefault();    
          if($('input[name="type"]').is(':checked'))
          {
              cuisine      = $('#cuisine').val();
              if(cuisine!='')
              {
                document.getElementById("Myform").submit();
                return true;
              }
              else
              {
                toastr.error("","Plese Select a cuisine");
              }
          }
          else
          {
                document.getElementById("Myform").submit();
                return true;
          }     
      });
  </script>
</html>
