<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('admin/includes/includes.php'); ?>
    <?php $this->load->view('admin/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('admin/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">FARE CARD FOR DRIVERS</h4>
                  
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                  <thead>
                    <tr>
                        <th>Base Fare</th>
                        <th>Free Distance</th>
                        <th>Free Time</th>
                        <th>Distance Charges</th>
                        <th>Time Charges</th>
                        <th>Free Waiting Time</th>
                        <th>Waiting Charges</th>
                        <th>Fixed Charge</th>
                        <th>Delivery Fees </th>
                        <th>Edit</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php foreach($cards as $ca){?>
                      <tr>
                          <td><?=$ca->base_fare?></td>
                          <td><?=$ca->free_distance?></td>
                          <td><?=$ca->free_time?></td>
                          <td><?=$ca->distance_charges?></td>
                          <td><?=$ca->time_charges?></td>
                          <td><?=$ca->free_waiting_time?></td>
                          <td><?=$ca->waiting_charges?></td>
                          <td><?=$ca->fixed_charge?></td>
                          <td><?=$ca->delivery_fees?></td>
                          <td><button class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="edit('<?=$ca->fc_id?>')">Edit</button></td>
                      </tr>
                    <?php };?>  
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('admin/includes/footer.php'); ?>
      
      <div class="modal fade" id="edit-style" tabindex="-1" role="dialog" aria-labelledby="modal-5">
            <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header bg-primary">
                  <h4 class="modal-title has-icon text-white">EDIT FARE CARD</h4>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                  <form class="form-horizontal" action="<?=site_url('admin/fare_card/editData')?>" method="post" id="edit-form">
                      <div class="form-group m-b-25">
                        <div class="col-12">
                           <label for="select">Base Fare</label>
                           <input type="text" class="form-control" name="base_fare" id="base_fare" required>
                           <input type="hidden" name="card_id" id="card_id">
                        </div>
                      </div>
                      <div class="form-group m-b-25">
                        <div class="col-12">
                           <label for="select">Free Distance</label>
                           <input type="text" class="form-control" name="free_distance" id="free_distance" required>
                        </div>
                      </div>
                      <div class="form-group m-b-25">
                        <div class="col-12">
                           <label for="select">Free Time</label>
                           <input type="text" class="form-control" name="free_time" id="free_time" required>
                        </div>
                      </div>
                      <div class="form-group m-b-25">
                        <div class="col-12">
                           <label for="select">Distance Charges</label>
                           <input type="text" class="form-control" name="distance_charges" id="distance_charges" required>
                        </div>
                      </div>
                      <div class="form-group m-b-25">
                        <div class="col-12">
                           <label for="select">Time Charges</label>
                           <input type="text" class="form-control" name="time_charges" id="time_charges" required>
                        </div>
                      </div>
                      <div class="form-group m-b-25">
                        <div class="col-12">
                           <label for="select">Free Waiting Time</label>
                           <input type="text" class="form-control" name="free_waiting_time" id="free_waiting_time" required>
                        </div>
                      </div>
                      <div class="form-group m-b-25">
                        <div class="col-12">
                           <label for="select">Waiting Charge</label>
                           <input type="text" class="form-control" name="waiting_charges" id="waiting_charges" required>
                        </div>
                      </div>
                      <div class="form-group m-b-25">
                        <div class="col-12">
                           <label for="select">Fixed Charge</label>
                           <input type="text" class="form-control" name="fixed_charge" id="fixed_charge" required>
                        </div>
                      </div>
                      <div class="form-group m-b-25">
                        <div class="col-12">
                           <label for="select">Delivery Fees</label>
                           <input type="text" class="form-control" name="delivery_fees" id="delivery_fees" required>
                        </div>
                      </div>

                   </div>
                      <div class="modal-footer">
                        <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                        <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit" id="submit-button">Update</button>
                      </div>
                  </form>
              </div>
            </div>
          </div>

    </div>
  </body>
  <?php $this->load->view('admin/includes/scripts.php'); ?>
  <?php $this->load->view('admin/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
  <script type="">
     function add()
      {
        $('#add-style').modal('show');
      }

      function edit(id)
      {
        $('#card_id').val(id);
        // alert(id);
        $.ajax({
          method: "POST",
          url: "<?=site_url('admin/fare_card/getDetails');?>",
          data : { id : id },
          dataType : "json",
          success : function(data)
          {
            // alert(data.name);
            $('#base_fare').val(data.base_fare);
            $('#free_distance').val(data.free_distance);
            $('#free_time').val(data.free_time);
            $('#distance_charges').val(data.distance_charges);
            $('#time_charges').val(data.time_charges);
            $('#free_waiting_time').val(data.free_waiting_time);
            $('#waiting_charges').val(data.waiting_charges);
            $('#fixed_charge').val(data.fixed_charge);
            $('#delivery_fees').val(data.delivery_fees);
            $('#edit-style').modal('show');
          }
        });
      }
  </script>
</html>
