<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('admin/includes/includes.php'); ?>
    <?php $this->load->view('admin/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('admin/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">DRIVERS</h4>
                 
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                        <th width="20%">Driver Name</th>
                        <th width="15%">Phone</th>
                        <th width="15%">Email</th>
                        <th width="20%">Vehicle Number</th>
                        <th width="10%">JRMS Code</th>
                        <th width="20%">City</th>
                        <th width="10%">Status</th>
                        <th width="5">Edit</th>
                        <th width="5">Delete</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach($drivers as $driver){?>
                        <tr>
                            <?php 
                             if ($driver->status=='1') 
                                {
                                  $status = "Active";
                                  $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$driver->dr_id.')" >Disable</a>';
                                }
                                else 
                                {
                                  $status = "Blocked";
                                  $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$driver->dr_id.')">Enable</a>';
                                }
                            ?>
                            <td><?=$driver->name?></td>
                            <td><?=$driver->phone?></td>
                            <td><?=$driver->email?></td>
                            <td><?=$driver->vehicle_number?></td>
                            <td><?=$driver->jrms_code?></td>
                            <td><?=$driver->city?></td>
                            <td><?=$status.'<br>'.$action;?></td>
                            <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="<?=site_url('admin/drivers/edit/'.$driver->dr_id)?>">Edit</a></td>
                            <td><a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="del(<?=$driver->dr_id?>)" >Delete</a></td>
                        </tr>
                      <?php };?>  
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="disable-driver" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DISABLE DRIVER</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to disable this driver?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('admin/drivers/disable')?>" method="post">
                      <input type="hidden" name="driver_id" id="disable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Disable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="enable-driver" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ENABLE DRIVER</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to enable this driver?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('admin/drivers/enable')?>" method="post">
                      <input type="hidden" name="driver_id" id="enable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Enable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="delete-driver" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DELETE DRIVER</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to delete this driver?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('admin/drivers/delete')?>" method="post">
                      <input type="hidden" name="driver_id" id="delete_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Delete</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
      </div>
      <?php $this->load->view('admin/includes/footer.php'); ?>
    </div>
  </body>
  <?php $this->load->view('admin/includes/scripts.php'); ?>
  <?php $this->load->view('admin/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
  <!--<script type="text/javascript">-->
  <!--  $(document).ready(function(){-->
  <!--    var dataTable = $('#user_data').DataTable({-->
  <!--      "processing":true,-->
  <!--      "serverSide":true,-->
  <!--      "order":[],-->
  <!--      "ajax":{-->
  <!--        url:"<?=site_url('admin/drivers/get')?>",-->
  <!--        type:"POST"-->
  <!--      },-->
  <!--      "columnDefs":[-->
  <!--        {-->
  <!--          "target":[0,3,4],-->
  <!--          "orderable":true-->
  <!--        }-->
  <!--      ]-->
  <!--    });-->
  <!--  });-->
  <!--</script>-->
  <script>
      function disable(c_id)
    	{
    		$('#disable_id').val(c_id);
    		$('#disable-driver').modal('show');
    	}
    	function enable(c_id)
    	{
    		$('#enable_id').val(c_id);
    		$('#enable-driver').modal('show');
    	}
        function del(c_id)
    	{
    	   // alert(c_id);
    		$('#delete_id').val(c_id);
    		$('#delete-driver').modal('show');
    	}
  </script>
</html>
