<!DOCTYPE html>
<html>
    <head>
      <?php $this->load->view('admin/includes/includes'); ?>
    </head>
    <body>
        <div id="wrapper">
            <?php $this->load->view('admin/includes/sidebar'); ?>

            <div class="content-page">
                <!-- Start content -->
                <div class="content">
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
                                    <h4 class="page-title float-left">Dashboard</h4>
                                    <ol class="breadcrumb float-right">
                                        <li class="breadcrumb-item"><a href="#">Sigofood</a></li>
                                        <li class="breadcrumb-item active">Dashboard</li>
                                    </ol>
                                    <div class="clearfix"></div>
                                </div>
                            </div>
                        </div>
                        <!-- end row -->
                        <div class="row">
                            <div class="col-xs-12 col-md-6 col-lg-6 col-xl-3">
                                <a href="<?=site_url('admin/orders/new')?>">
                                    <div class="card-box tilebox-one">
                                        <i class="fa fa-shopping-cart float-right"></i>
                                        <h6 class="text-muted text-uppercase mb-3"> Orders<br> (<?php echo date('M Y'); ?> )</h6>
                                         <h4 class="mb-3" data-plugin="counterup"><?=$order?></h4> 
                                    </div>
                                </a>
                            </div>
                            
                            <div class="col-xs-12 col-md-6 col-lg-6 col-xl-3">
                                <a href="<?=site_url('admin/orders/new')?>">
                                    <div class="card-box tilebox-one">
                                        <i class="fa fa-shopping-cart float-right"></i>
                                        <h6 class="text-muted text-uppercase mb-3"> Today's Orders<br> (<?php echo date('d M Y'); ?> )</h6>
                                         <h4 class="mb-3" data-plugin="counterup"><?=$order_today?></h4> 
                                    </div>
                                </a>
                            </div>
                            
                            <div class="col-xs-12 col-md-6 col-lg-6 col-xl-3">
                                <a href="<?=site_url('admin/orders/cancelled')?>">
                                    <div class="card-box tilebox-one">
                                        <i class="fa fa-shopping-cart float-right"></i>
                                        <h6 class="text-muted text-uppercase mb-3"> Cancelled Orders Today<br> (<?php echo date('d M Y'); ?> )</h6>
                                         <h4 class="mb-3" data-plugin="counterup"><?=$cancelled_today?></h4> 
                                    </div>
                                </a>
                            </div>

                            <div class="col-xs-12 col-md-6 col-lg-6 col-xl-3">
                                <a href="<?=site_url('admin/restaurants')?>">  
                                    <div class="card-box tilebox-one">
                                        <i class="fa fa-coffee float-right"></i>
                                        <h6 class="text-muted text-uppercase mb-3">Active Restaurants</h6>
                                        <h4 class="mb-3" data-plugin="counterup"><?=$restaurant?></h4>
                                    </div>
                                </a>    
                            </div>

                            <!--<div class="col-xs-12 col-md-6 col-lg-6 col-xl-3">-->
                            <!--    <a href="<?=site_url('admin/cuisines')?>">-->
                            <!--        <div class="card-box tilebox-one">-->
                            <!--            <i class="fa fa-cutlery float-right"></i>-->
                            <!--            <h6 class="text-muted text-uppercase mb-3">Total Cuisines</h6>-->
                            <!--            <h4 class="mb-3" data-plugin="counterup"><?=$cuisine?></h4>-->
                            <!--        </div>-->
                            <!--    </a>    -->
                            <!--</div>-->

                            <div class="col-xs-12 col-md-6 col-lg-6 col-xl-3">
                                <a href="<?=site_url('admin/customers')?>">
                                    <div class="card-box tilebox-one">
                                        <i class="fa fa-users float-right"></i>
                                        <h6 class="text-muted text-uppercase mb-3">Total Customers</h6>
                                        <h4 class="mb-3" data-plugin="counterup"><?=$user?></h4>
                                    </div>
                                </a>    
                            </div>
                        </div>
                        <!-- end row -->
                        <div class="row">
                            <!-- <div class="col-lg-4">
                                <div class="card-box">
                                    <h4 class="header-title mb-4">New Orders</h4>
                                    <div class="inbox-widget slimscroll" style="max-height: 670px;"> -->
                                      <!-- <?php foreach ($orders as $order) { ?>
                                        <a href="<?=site_url('admin/orders/active')?>">
                                            <div class="inbox-item">
                                                <p class="inbox-item-author">Order ID: ORD<?=$order->order_id?></p>
                                                <p class="inbox-item-author">User: <?=$order->firstname.' '.$order->lastname ?></p>
                                                <p class="inbox-item-text">Restaurant: <?=$order->rest_name?></p>
                                                <p class="inbox-item-text">Status: <?=$order->status?></p>
                                            </div>
                                        </a>
                                     <?php } ?> -->
                                   <!--  </div>
                                </div>
                            </div> -->

                            <div class="col-lg-4">
                                <div class="card-box">
                                    <h4 class="header-title mb-4">New Restaurants</h4>
                                    <div class="inbox-widget slimscroll" style="max-height: 670px;">
                                      <?php foreach ($restaurants as $rest) { ?>
                                        <a href="<?=site_url('admin/restaurants')?>">
                                            <div class="inbox-item">
                                                <div class="inbox-item-img"><img src="<?=base_url() . $rest->cover_image?>" class="rounded-circle bx-shadow-lg" alt=""></div>
                                                <p class="inbox-item-author"><?=$rest->rest_name?></p><br>
                                                <!--<p class="inbox-item-text"><?=$rest->rest_email?></p>-->
                                                <!--<p class="inbox-item-text"><?=$rest->rest_phone?></p>-->
                                                <span class="pull-right text-success tran-price"><?=$rest->rest_email?></span> <br>
                                                <span class="pull-right text-success tran-price"><?=$rest->rest_phone?></span> 
                                            </div>
                                        </a>
                                     <?php } ?>
                                    </div>
                                </div>
                            </div>

                            <!--<div class="col-lg-4">-->
                            <!--    <div class="card-box">-->
                            <!--        <h4 class="header-title mb-4">New Cuisines</h4>-->
                            <!--        <div class="inbox-widget slimscroll" style="max-height: 670px;">-->
                            <!--          <?php foreach ($cuisines as $c) { ?>-->
                            <!--            <a href="<?=site_url('admin/cuisines')?>">-->
                            <!--                <div class="inbox-item">-->
                            <!--                    <p class="inbox-item-author"><?=$c->name?></p>-->
                            <!--                </div>-->
                            <!--            </a>-->
                            <!--         <?php } ?>-->
                            <!--        </div>-->
                            <!--    </div>-->
                            <!--</div>-->
                            
                            <div class="col-lg-4">
                                <div class="card-box">
                                    <h4 class="header-title mb-4">New Orders</h4>
                                    <div class="inbox-widget slimscroll" style="max-height: 670px;">
                                      <?php foreach ($orders as $ord) { ?>
                                        <a href="<?=site_url('admin/orders/new')?>">
                                            <div class="inbox-item">
                                                <p class="inbox-item-author">ORD<?=$ord->order_id?></p>
                                                <p class="inbox-item-author">Restaurant: <?=$ord->rest_name?></p>
                                                <p class="inbox-item-author">Price: <?=number_format($ord->total,'3')?> BHD</p>
                                                <p class="inbox-item-text">User: <?=$ord->firstname.' '.$ord->lastname ?></p>
                                                <p class="inbox-item-text">Ordered On: <?php echo date('d M Y',strtotime($ord->ordered_date));?>, <?php echo $ord->ordered_time;?></p>
                                            </div>
                                        </a>
                                     <?php } ?>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="card-box">
                                    <h4 class="header-title mb-4">New Customers</h4>
                                    <div class="inbox-widget slimscroll" style="max-height: 670px;">
                                      <?php foreach ($users as $user) { ?>
                                        <a href="<?=site_url('admin/customers')?>">
                                            <div class="inbox-item">
                                            
                                                <p class="inbox-item-author"><?=$user->firstname.' '.$user->lastname ?></p>
                                                <p class="inbox-item-text"><?=$user->email?></p>
                                                <p class="inbox-item-text"><?=$user->mobile?></p>
                                                <p class="inbox-item-text">Registered On: <?php echo date('d M Y',strtotime($user->timestamp)).', '.date('h:i A',strtotime($user->timestamp)); ?></p>
                                            </div>
                                        </a>
                                     <?php } ?>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div> <!-- container -->
                </div> <!-- content -->
                <?php $this->load->view('admin/includes/footer') ?>
            </div>
        </div>
        <?php $this->load->view('admin/includes/scripts') ?>
    </body>
</html>
