<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('admin/includes/includes.php'); ?>
    <?php $this->load->view('admin/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('admin/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">CUSTOMERS</h4>
                 
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="user_data" class="table table-bordered table-striped">
                    <thead>
                       <tr>
                        <th width="40%">Name</th>
                        <th width="25%">Phone</th>
                        <th width="25%">Email</th>
                        <th width="10%">Status</th>
                       </tr>
                    </thead>
                  </table>
                </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="disable-customer" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DISABLE CUSTOMER</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to disable this customer?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('admin/customers/disable')?>" method="post">
                      <input type="hidden" name="cust_id" id="disable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Disable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="enable-customer" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ENABLE CUSTOMER</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to enable this customer?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('admin/customers/enable')?>" method="post">
                      <input type="hidden" name="cust_id" id="enable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Enable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
      </div>
      <?php $this->load->view('admin/includes/footer.php'); ?>
    </div>
  </body>
  <?php $this->load->view('admin/includes/scripts.php'); ?>
  <?php $this->load->view('admin/includes/table-script.php'); ?>
  <script type="text/javascript">
    $(document).ready(function(){
      var dataTable = $('#user_data').DataTable({
        "processing":true,
        "serverSide":true,
        "order":[],
        "ajax":{
          url:"<?=site_url('admin/customers/get')?>",
          type:"POST"
        },
        "columnDefs":[
          {
            "target":[0,3,4],
            "orderable":true
          }
        ]
      });
    });
  </script>
  <script>
      function disable(c_id)
    	{
    		$('#disable_id').val(c_id);
    		$('#disable-customer').modal('show');
    	}
    	function enable(c_id)
    	{
    		$('#enable_id').val(c_id);
    		$('#enable-customer').modal('show');
    	}
    
  </script>
</html>
