<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('admin/includes/includes.php'); ?>
    <?php $this->load->view('admin/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('admin/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">CUISINES</h4>
                  <ol class="breadcrumb float-right">
                    <button type="button" class="btn btn-gradient btn-rounded waves-light waves-effect w-md" onclick="add()">Add Cuisine</button>
                  </ol>
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                        <th width="20%">Cuisine Image</th>  
                        <th width="60%">Cuisine Name</th>
                        <th width="20%">Status</th>
                        <th width="20%">Edit</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach($cuisines as $cu){?>
                        <tr>
                            <?php 
                             if ($cu->status) 
                                {
                                  $status = "Active";
                                  $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$cu->c_id.')" >Disable</a>';
                                }
                                else 
                                {
                                  $status = "Blocked";
                                  $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$cu->c_id.')">Enable</a>';
                                }
                            ?>
                            <td><img src="<?=base_url(). $cu->image; ?>" width="100%"></td>
                            <td><?=$cu->name?></td>
                            <td><?=$status.'<br>'.$action;?></td>
                            <td><button class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:13px;" onclick="edit('<?=$cu->c_id?>')">Edit</button></td>
                        </tr>
                      <?php };?>  
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('admin/includes/footer.php'); ?>
      
      <div class="modal fade" id="add-style" tabindex="-1" role="dialog" aria-labelledby="modal-5">
        <div class="modal-dialog modal-dialog-centered" role="document">
          <div class="modal-content">
            <div class="modal-header bg-primary">
              <h4 class="modal-title has-icon text-white">ADD CUISINE</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
              <form class="form-horizontal" action="<?=site_url('admin/cuisines/addData')?>" method="post" id="add-form" enctype="multipart/form-data">
                 <div class="form-group m-b-25">
                     <div class="col-12">
                         <label for="select">Cuisine Name<span style="color: red; ">*</span></label>
                         <input type="text" class="form-control" name="name"  required oninput="(function(e){e.setCustomValidity(''); return !e.validity.valid && e.setCustomValidity(' ')})(this)" oninvalid="this.setCustomValidity('Please enter the cuisine name!')"/>
                     </div>
                 </div>
                 <div class="form-group m-b-25">
                     <div class="col-12">
                         <label for="select">Cuisine Image<span style="color: red; ">*</span></label>
                         <input type="file" class="form-control" name="image" onchange="preview_image(this)" required>
                     </div>
                 </div>
               </div>
               <div class="modal-footer">
                 <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                 <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit" id="submit-button">Add</button>
               </div>
              </form>
          </div>
        </div>
      </div>

      <div class="modal fade" id="edit-style" tabindex="-1" role="dialog" aria-labelledby="modal-5">
        <div class="modal-dialog modal-dialog-centered" role="document">
          <div class="modal-content">
            <div class="modal-header bg-primary">
              <h4 class="modal-title has-icon text-white">EDIT CUISINE</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
              <form class="form-horizontal" action="<?=site_url('admin/cuisines/editData')?>" method="post" enctype="multipart/form-data" id="edit-form">
                 <div class="form-group m-b-25">
                    <div class="form-group m-b-25">
                        <div class="col-12">
                           <label for="select">Cuisine Name</label>
                           <input type="text" class="form-control" name="name" id="name" required oninput="(function(e){e.setCustomValidity(''); return !e.validity.valid && e.setCustomValidity(' ')})(this)" oninvalid="this.setCustomValidity('Please enter the cuisine name!')"/>
                           <input type="hidden" name="cuisine_id" id="cuisine_id">
                        </div>
                    </div>
                    <div class="form-group m-b-25">
                     <div class="col-12">
                         <label for="select">Cuisine Image ( If you wish to change the image choose image or leave this field empty )</label>
                         
                         <input type="file" class="form-control" name="image" onchange="preview_image(this)">
                     </div>
                 </div>
                  </div>
            </div>
            <div class="modal-footer">
                <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit" id="submit">Update</button>
             </div>
              </form>
          </div>
        </div>
      </div>
     
     <div class="modal fade" id="disable-cuisine" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DISABLE CUISINE</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to disable this cuisine?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('admin/cuisines/disable')?>" method="post">
                      <input type="hidden" name="c_id" id="cuisine_disable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Disable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="enable-cuisine" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ENABLE CUISINE</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to enable this cuisine?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('admin/cuisines/enable')?>" method="post">
                      <input type="hidden" name="c_id" id="cuisine_enable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Enable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
     
    </div>
  </body>
  <?php $this->load->view('admin/includes/scripts.php'); ?>
  <?php $this->load->view('admin/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
  <script type="">
     function add()
      {
        $('#add-style').modal('show');
      }

      function edit(id)
      {
        $('#cuisine_id').val(id);
        // alert(id);
        $.ajax({
          method: "POST",
          url: "<?=site_url('admin/cuisines/getDetails');?>",
          data : { id : id },
          dataType : "json",
          success : function(data)
          {
            // alert(data.name);
            $('#name').val(data.name);
            $('#edit-style').modal('show');
          }
        });
      }
  </script>
  <script>
      function preview_image(id)
      {
        var id = id.id;
        var x = document.getElementById(id);
        var size = x.files[0].size;
        if (size > 5000000) {
          toastr.error("Please select an image with size less than 5 mb."); 
          document.getElementById(id).value = "";
        }
        else {
          var val = x.files[0].type;
          var type = val.substr(val.indexOf("/") + 1);
          s_type = ['jpeg','jpg','png'];
          var flag = 0;
          for (var i = 0; i < s_type.length; i++) {
            if (s_type[i] == type) {
              flag = flag + 1;
            }
          }
          if (flag == 0) {
            toastr.error("This file format is not supported."); 
            document.getElementById(id).value = "";
          }
          else {
            var reader = new FileReader();
            reader.onload = function()
            {
              var cn = id.substring(3);
              var preview = 'preview' + cn;
              var output = document.getElementById(preview);
              output.src = reader.result;
            }
            reader.readAsDataURL(x.files[0]);
          }

        }
      }
  </script>
  <script>
      function disable(c_id)
    	{
    		$('#cuisine_disable_id').val(c_id);
    		$('#disable-cuisine').modal('show');
    	}
    	function enable(c_id)
    	{
    		$('#cuisine_enable_id').val(c_id);
    		$('#enable-cuisine').modal('show');
    	}
    
  </script>
</html>
