<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('admin/includes/includes.php'); ?>
    <?php $this->load->view('admin/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('admin/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">Cancel Reasons</h4>
                  <ol class="breadcrumb float-right">
                    <button type="button" class="btn btn-gradient btn-rounded waves-light waves-effect w-md" onclick="add()">Add Reasons</button>
                  </ol>
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                        <th width="25%">Reason For</th>
                        <th width="50%">Reason</th>
                        <th width="10%">Status</th>
                        <th width="10%">Edit</th>
                      </tr>
                    </thead>
                    <tbody>
                    <?php foreach($reasons as $rea){?>
                      <tr>
                          <?php 
                           if ($rea->status) 
                              {
                                $status = "Active";
                                $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$rea->cr_id.')" >Disable</a>';
                              }
                              else 
                              {
                                $status = "Blocked";
                                $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$rea->cr_id.')" >Enable</a>';
                              }
                          ?>
                          <td><?=$rea->reason_for?></td>
                          <td><?=$rea->reason?></td>
                          <td><?=$status.'<br>'.$action;?></td>
                          <td><button class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="edit('<?=$rea->cr_id?>')">Edit</td>
                      </tr>
                    <?php };?>  
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('admin/includes/footer.php'); ?>
      
         <div class="modal fade" id="add-style" tabindex="-1" role="dialog" aria-labelledby="modal-5">
            <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header bg-primary">
                  <h4 class="modal-title has-icon text-white">ADD CANCEL REASON</h4>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                  <form class="form-horizontal" action="<?=site_url('admin/cancel_reasons/addData')?>" method="post" id="add-form">
                    <div class="form-group m-b-25">
                         <div class="col-12">
                             <select class="form-control" id="reason_for" name="reason_for" required="">
                                <option value="Customer">Customer</option>
                             </select>
                         </div>
                     </div>
                     <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">Reason</label>
                             <textarea type="text" class="form-control" name="reason" id="reason" required></textarea>
                         </div>
                     </div>
                   </div>
                      <div class="modal-footer">
                        <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                        <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit" id="submit-button">Add</button>
                      </div>
                  </form>
              </div>
            </div>
          </div>

          <div class="modal fade" id="edit-style" tabindex="-1" role="dialog" aria-labelledby="modal-5">
            <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header bg-primary">
                  <h4 class="modal-title has-icon text-white">EDIT CANCEL REASON</h4>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                  <form class="form-horizontal" action="<?=site_url('admin/cancel_reasons/editData')?>" method="post" id="edit-form">
                    <div class="form-group m-b-25">
                         <div class="col-12">
                             <select class="form-control" id="reason_for" name="reason_for" required="">
                                <option value="Customer">Customer</option>
                             </select>
                         </div>
                     </div>
                     <div class="form-group m-b-25">
                        <div class="form-group m-b-25">
                        <div class="col-12">
                           <label for="select">Reason</label>
                            <textarea type="text" class="form-control" name="reason" id="c_reason" required></textarea>
                           <input type="hidden" name="reason_id" id="reason_id">
                        </div>
                   </div>
                     </div>
                   </div>
                      <div class="modal-footer">
                        <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                        <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit" id="submit-button">Update</button>
                      </div>
                  </form>
              </div>
            </div>
          </div>

        <div class="modal fade" id="disable-reason" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DISABLE REASON</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to disable this reason?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('admin/cancel_reasons/disable')?>" method="post">
                      <input type="hidden" name="reason_id" id="disable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Disable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="enable-reason" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ENABLE REASON</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to enable this reason?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('admin/cancel_reasons/enable')?>" method="post">
                      <input type="hidden" name="reason_id" id="enable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Enable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
    </div>
  </body>
  <?php $this->load->view('admin/includes/scripts.php'); ?>
  <?php $this->load->view('admin/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
  <script type="">
     function add()
      {
        $('#add-style').modal('show');
      }

      function edit(id)
      {
        $('#reason_id').val(id);
        // alert(id);
        $.ajax({
          method: "POST",
          url: "<?=site_url('admin/cancel_reasons/getDetails');?>",
          data : { id : id },
          dataType : "json",
          success : function(data)
          {
            // alert(data.name);
            $('#c_reason').val(data.reason);
            $('#edit-style').modal('show');
          }
        });
      }
  </script>
  <script>
      function disable(c_id)
    	{
    		$('#disable_id').val(c_id);
    		$('#disable-reason').modal('show');
    	}
    	function enable(c_id)
    	{
    		$('#enable_id').val(c_id);
    		$('#enable-reason').modal('show');
    	}
    
  </script>
</html>
