<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('admin/includes/includes.php'); ?>
    <?php $this->load->view('admin/includes/table-css.php'); ?>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('admin/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">BLOCKS</h4>
                  <ol class="breadcrumb float-right">
                    <button type="button" class="btn btn-gradient btn-rounded waves-light waves-effect w-md" onclick="add()">Add Block</button>
                  </ol>
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
                <div class="card-box table-responsive">
                  <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                        <th>Block Number</th>
                        <th>Place Name</th>
                        <th>City</th>
                        <th>Status</th>
                        <th>Edit</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach($blocks as $block){?>
                        <tr>
                            <?php 
                             if ($block->block_status==1) 
                                {
                                  $status = "Active";
                                  $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$block->block_id.')" >Disable</a>';
                                }
                                else 
                                {
                                  $status = "Blocked";
                                  $action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$block->block_id.')" >Enable</a>';
                                }
                            ?>
                            <td><?=$block->block_name?></td>
                            <td><?=$block->place_name?></td>
                            <td><?=$block->name?></td>
                            <td><?=$status.'<br>'.$action;?></td>
                            <td><button class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:13px;" onclick="edit('<?=$block->block_id?>')">Edit</button></td>
                        </tr>
                      <?php };?>  
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('admin/includes/footer.php'); ?>
      
         <div class="modal fade" id="add-style" tabindex="-1" role="dialog" aria-labelledby="modal-5">
            <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header bg-primary">
                  <h4 class="modal-title has-icon text-white">ADD BLOCK</h4>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                  <form class="form-horizontal" action="<?=site_url('admin/blocks/addData')?>" method="post" id="add-form">
                     <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">City<span style="color: red;">*</span></label>
                             <select class="form-control" name="city_id" required>    
                             <option value="">---Select City---</option>
                             <?php foreach($cities as $city) {?>
                              <option value="<?=$city->place_id?>"><?=$city->name?></option>
                             <?php };?>
                             </select>
                         </div>
                      </div>
                      <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">Place Name</label>
                             <input type="text" minlength="3" class="form-control" name="place_name" placeholder="Place Name" required>
                         </div>
                     </div>
                     <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">Block Number</label>
                             <input type="number" min="0" class="form-control" name="name" placeholder="Block number" required>
                         </div>
                     </div>
                   </div>
                      <div class="modal-footer">
                        <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                        <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit" id="submit-button">Add</button>
                      </div>
                  </form>
              </div>
            </div>
          </div>

          <div class="modal fade" id="edit-style" tabindex="-1" role="dialog" aria-labelledby="modal-5">
            <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header bg-primary">
                  <h4 class="modal-title has-icon text-white">EDIT BLOCK</h4>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                  <form class="form-horizontal" action="<?=site_url('admin/blocks/editData')?>" method="post" id="edit-form">
                      <div class="form-group m-b-25">
                         <div class="col-12">
                             <label for="select">City<span style="color: red;">*</span></label>
                             <select class="form-control"  name="city_id" id="city" required>                         
                             </select>
                         </div>
                      </div>
                      <div class="form-group m-b-25">
                        <div class="col-12">
                           <label for="select">Place Name</label>
                           <input type="text" minlength="3" class="form-control" name="place_name" id="place_name" required>
                        </div>
                     </div>
                      <div class="form-group m-b-25">
                        <div class="col-12">
                           <label for="select">Block Number</label>
                           <input type="number" min="0" class="form-control" name="name" id="name" required>
                           <input type="hidden" name="block_id" id="block_id">
                        </div>
                     </div>
                   </div>
                   <div class="modal-footer">
                      <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                      <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit" id="submit">Update</button>
                   </div>
                  </form>
              </div>
            </div>
          </div>

        <div class="modal fade" id="disable-place" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">DISABLE BLOCK</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to disable this block?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('admin/blocks/disable')?>" method="post">
                      <input type="hidden" name="block_id" id="disable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Disable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>
        
        <div class="modal fade" id="enable-place" tabindex="-1" role="dialog" aria-labelledby="modal-5">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header bg-primary">
                <h4 class="modal-title has-icon text-white">ENABLE BLOCK</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
               <div class="modal-body">
                  <p>Are you sure to enable this block?</p>
               </div>
               <div class="modal-footer">
                   <button type="reset" class="btn w-lg btn-rounded btn-light waves-effect m-l-5" data-dismiss="modal">Back</button>
                  <form class="form-horizontal" action="<?=site_url('admin/blocks/enable')?>" method="post">
                      <input type="hidden" name="block_id" id="enable_id">
                     <button class="btn w-lg btn-rounded btn-primary waves-effect waves-light" type="submit">Enable</button>
                  </form>
               </div>
            </div>
          </div>
        </div>

    </div>
  </body>
  <?php $this->load->view('admin/includes/scripts.php'); ?>
  <?php $this->load->view('admin/includes/table-script.php'); ?>
  <script type="text/javascript">
    $('#datatable').DataTable({
           "ordering": false
           });
  </script> 
  <script type="">
     function add()
      {
        $('#add-style').modal('show');
      }

      function edit(id)
      {
        $('#block_id').val(id);
        // alert(id);
        $.ajax({
          method: "POST",
          url: "<?=site_url('admin/blocks/getDetails');?>",
          data : { id : id },
          dataType : "json",
          success : function(data)
          {
            var block    = data.block;
            var city     = data.cities;
            
            $('#name').val(block.block_name);
            $('#place_name').val(block.place_name);
            $('#city').html(city);
            $('#edit-style').modal('show');
          }
        });
      }
  </script>
  <script>
      function disable(c_id)
    	{
    		$('#disable_id').val(c_id);
    		$('#disable-place').modal('show');
    	}
    	function enable(c_id)
    	{
    		$('#enable_id').val(c_id);
    		$('#enable-place').modal('show');
    	}
    
  </script>
</html>
