<!DOCTYPE html>
<html>
  <head>
    <?php $this->load->view('admin/includes/includes.php'); ?>
    <link rel="stylesheet" href="<?=base_url()?>plugins/image-crop/croppie.css">

    <link href="<?=base_url()?>plugins/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet">
    <link href="<?=base_url()?>plugins/clockpicker/css/bootstrap-clockpicker.min.css" rel="stylesheet">
    <style type="text/css">
      .bootstrap-datetimepicker-widget tr:hover {
       background-color: #808080;
     }
    </style>
  </head>
  <body>
    <div id="wrapper">
      <?php $this->load->view('admin/includes/sidebar.php'); ?>
      <div class="content-page">
        <div class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="page-title-box">
                  <h4 class="page-title float-left">EDIT ADVERTISEMENT</h4>
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
              <div class="card-box">
                <form  id="add-form" action="<?=site_url('admin/advertisements/editData')?>" method="post" enctype="multipart/form-data">
                  <div class="form-row">
                    <div class="col-md-8">
                      <label>Title<span style="color: red;">*</span></label>
                      <div class="input-group">
                        <input type="text" name="title" value="<?=$popup->title?>" class="form-control"  placeholder="Enter Title" required>
                        <input type="hidden" name="adv_id" value="<?=$popup->pop_id?>">
                      </div>
                      <br>
                    </div>
                    <div class="col-md-8">
                      <label>City<span style="color: red;">*</span></label>
                      <div class="input-group">
                        <select name="city" class="form-control" required>
                          <option value="">---Select City---</option>
                          <?php foreach($places as $place) {?>
                            <option value="<?=$place->place_id?>" <?php if($popup->place_id==$place->place_id) {?> selected <?php };?>><?=$place->name?></option>
                          <?php };?>
                        </select>
                      </div>
                      <br>
                    </div>
                    <div class="col-md-8">
                      <label>Start Date<span style="color: red;">*</span></label>
                      <div class="input-group">
                        <input type="date" name="start_date" id="start_date" class="form-control"  placeholder="Start Date" value="<?=$popup->start_date?>" required>
                      </div>
                      <br>
                    </div>
                    <div class="col-md-8">
                      <label>End Date<span style="color: red;">*</span></label>
                      <div class="input-group">
                        <input type="date" name="end_date" id="end_date" class="form-control"  placeholder="End Date" value="<?=$popup->end_date?>" required>
                      </div>
                      <br>
                    </div>
                   
                    <div class="col-md-8">
                      <label>Image ( If you wish to change the image choose image or leave this field empty )(400X300 pixels)</label>
                      <div class="input-group">
                        <input type="file" class="form-control" id="upload" accept="image/*">
                      </div>
                      <br>
                    </div>
                    
                    <div class="col-md-12">
                        <div id="current-image">
                          <img src="<?=base_url() . $popup->image?>" height="300px" width="400px">
                        </div>
                        <div class="upload-div" style="display:none;">
                          <div id="upload-demo"></div>
                          <div class="col-12 text-center">
                            <a href="#" class="btn btn-primary btn-flat" style="border-radius : 5px;" id="crop-button">Crop</a>
                          </div>
                        </div>
                        <div class="upload-result text-center" id="upload-result" style="display : none; margin-bottom:10px;">

                        </div>
                        <input type="hidden" name="image" id="ameimg" >
                     </div>
                   
                  </div>
                  <div class="form-row">
                    <div class="col-md-12 mt-4">
                      <button type="submit" class="btn btn-success waves-light waves-effect w-md pull-right" id="submit-button" style="display:block;">Update</button>
                    </div>
                  </div>  
                </div>

                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
      <?php $this->load->view('admin/includes/footer.php'); ?>
    </div>
  </body>
  <?php $this->load->view('admin/includes/scripts.php'); ?>
  <script src="<?=base_url()?>plugins/image-crop/croppie.js"></script>

  <script src="<?=base_url()?>plugins/bootstrap-timepicker/bootstrap-timepicker.js"></script>
  <script src="<?=base_url()?>assets/pages/jquery.form-pickers.init.js"></script>
    <script type="text/javascript">
      $uploadCrop = $('#upload-demo').croppie({
          enableExif: true,
          viewport: {
              width: 400,
              height: 300,
              type: 'rectangle'
          },
          boundary: {
              width: 500,
              height: 400
          }
      });
    
    
      $('#upload').on('change', function () {
        $("#submit-button").css("display", "none");
        var file = $("#upload")[0].files[0];
        var val = file.type;
        var type = val.substr(val.indexOf("/") + 1);
        if (type == 'png' || type == 'jpg' || type == 'jpeg') {
    
          $("#current-image").css("display", "none");
          $("#submit-button").css("display", "none");
    
          $(".upload-div").css("display", "block");
          $("#submit-button").css("display", "none");
          var reader = new FileReader();
            reader.onload = function (e) {
              $uploadCrop.croppie('bind', {
                url: e.target.result
              }).then(function(){
                console.log('jQuery bind complete');
              });
    
            }
            reader.readAsDataURL(this.files[0]);
        }
        else {
          alert('This file format is not supported.');
          document.getElementById("upload").value = "";
          $("#upload-result").css("display", "none");
          $("#submit-button").css("display", "none");
          $("#current-image").css("display", "block");
          $('#ameimg').val('');
        }
      });
    
    
      $('#crop-button').on('click', function (ev) {
          $("#submit-button").css("display", "block");
        $uploadCrop.croppie('result', {
          type: 'canvas',
          size: 'viewport'
        }).then(function (resp) {
          html = '<img src="' + resp + '" />';
          $("#upload-result").html(html);
          $("#upload-result").css("display", "block");
          $(".upload-div").css("display", "none");
          $("#submit-button").css("display", "block");
          $('#ameimg').val(resp);
        });
      });
  </script>
  <script type="">
    function preview_image(id) 
    {
        var id = id.id;
        var x = document.getElementById(id);
        var size = x.files[0].size;
        if (size > 5000000) {
           toastr.error("Failed","Please select an image with size less than 5 mb.");
          document.getElementById(id).value = "";
        }
        else {
          var val = x.files[0].type;
          var type = val.substr(val.indexOf("/") + 1);
          s_type = ['jpeg','jpg','png'];
          var flag = 0;
          for (var i = 0; i < s_type.length; i++) {
            if (s_type[i] == type) {
              flag = flag + 1;
            }
          }
          if (flag == 0) {
            toastr.error("Failed","This file format is not supported.");
            document.getElementById(id).value = "";
          }
          else {
                let img = new Image()
                img.src = window.URL.createObjectURL(event.target.files[0])
                img.onload = () => {
                   if(img.width === 400 && img.height === 300)
                   {
                        var reader = new FileReader();
                        reader.onload = function()
                        {
                          var cn = id.substring(3);
                          var preview = 'preview' + cn;
                          var output = document.getElementById(preview);
                          output.src = reader.result;
                        }
                        reader.readAsDataURL(x.files[0]);
                    }
                    else
                    {
                        toastr.error(`Sorry, this image doesn't look like the size we wanted. It's ${img.width} x ${img.height} but we require 400 x 300 size image.`);
                        document.getElementById(id).value = "";
                    }
                }
          }

        }
    }
  </script>
  <script type="">
      $('#add-form').on('submit', function(e){
      e.preventDefault();
      
      var today      = new Date().toISOString().split('T')[0];  
      var start      = $('#start_date').val();
      var end        = $('#end_date').val();
      var place_id   = $('#place_id').val();  

      if (start < today)
      {
        toastr.error("","Start date cannot be lesser than current date"); 
      }
      else if (end == start)
      {
        toastr.error("","End date should be greater than start date"); 
      }
      else if (end < start)
      {
        toastr.error("","End date cannot be lesser than start date"); 
      }
      else 
      {   
           document.getElementById("add-form").submit();       
            return true; 
      }
    });
  </script>
</html>
