<?php
class Model_styles extends CI_Model 
{   
    function __construct()
    {
      $this->load->database();
    }
    public function insert($table, $data) 
    {
        $this->db->insert($table, $data);
        $insert_id = $this->db->insert_id();
        return $insert_id;
    }
    public function get_details($table, $cond) {
        $res = $this->db->get_where($table, $cond);
        return $res;
    }
    public function update($base_id, $id, $table, $data) {
        $this->db->where($base_id, $id);
        $this->db->update($table, $data);
        return true;
    }
    public function delete($table, $cond) 
    {
        $this->db->delete($table, $cond);
        return true;
    }
    public function getRestaurantStyles($id) 
    {
        $this->db->select('*');
        $this->db->from('restaurant_types');
        $this->db->join('restaurant_styles', 'restaurant_styles.rs_id=restaurant_types.rs_id');
        $this->db->where('r_id', $id);
        $this->db->order_by('rt_id', 'desc');
        return $this->db->get()->result();
    }
    public function getStyles() 
    {
        $this->db->select('restaurant_styles.*');
        $this->db->from('restaurant_styles');
        $this->db->where('status', '1');
        $this->db->order_by('rs_id', 'desc');
        return $this->db->get()->result();
    }
    public function check($style_id, $rest_id) 
    {
        $this->db->select('rt_id');
        $this->db->from('restaurant_types');
        $this->db->where('r_id', $rest_id);
        $this->db->where('rs_id', $style_id);
        $result = $this->db->get()->num_rows();
        if ($result > 0) {
            return true;
        } else {
            return false;
        }
    }
}
?>
