<?php

class M_promotion extends CI_Model
{
    function __construct()
    {
       $this->load->database();
    }
  
    function getPromotions($id)
    {
        $this->db->select('*');
        $this->db->from('promotions');
        $this->db->where('r_id',$id);
        $this->db->order_by('pr_id','desc');
        $result=$this->db->get();
        return $result->result();
    }
  
    function getPromotionCategories($id)
    {
        $this->db->select('*');
        $this->db->from('promotion_category');
        $this->db->where('r_id',$id);
        $this->db->order_by('pcat_id','desc');
        $result=$this->db->get();
        return $result->result();
    }
  
    public function checkCatName($name,$rest)
    {
        $query = "SELECT STRCMP(promotion_category.cat_name, '$name') as length FROM promotion_category WHERE r_id='$rest' HAVING length='0'";
        $res = $this->db->query($query);
        return $res->num_rows();
    }
  
    public function checkCatById($name,$id,$rest)
    {
        $query = "SELECT STRCMP(promotion_category.cat_name, '$name') as length FROM promotion_category WHERE r_id='$rest' AND pcat_id!='$id' HAVING length='0'";
        $res = $this->db->query($query);
        return $res->num_rows();
   }
  
   function getProducts($id)
   {
        $this->db->select('product_price.*,products.name');
        $this->db->from('product_price');
        $this->db->join('products','products.p_id=product_price.product_id');
        $this->db->where('products.r_id',$id);
        $this->db->where('products.status','Active');
        $this->db->where('product_price.status','1');
        $this->db->order_by('product_price.price_id','desc');
        $result=$this->db->get();
        return $result->result();
  }
  
  function get_smallest_price($id)
  {
    $this->db->select('MIN(price) as min_price');
    $this->db->from('product_price');
    $this->db->where('product_id',$id);
    return $this->db->get()->row()->min_price;
  }
  
}

?>
