<?php

class M_products extends CI_Model
{
  function __construct()
  {
    $this->load->database();
  }
  function make_query()
  {
    $restaurant    = $this->session->userdata['restaurant'];
    $restaurant_id = $restaurant['restaurant_id'];

    $table = "products";
    $select_column = array("p_id","r_id","name","sku","description","ingredients","price","time_starts","time_ends","sequence","prep_time","cover_image","status");
    $order_column = array(null,null,"name","sku",null,null,null,null);

    $this->db->select($select_column);
    $this->db->from($table);
    $this->db->where('r_id',$restaurant_id);
    if (isset($_POST["search"]["value"])) 
    {
      $this->db->like("name",$_POST["search"]["value"]);
      $this->db->or_like("sku",$_POST["search"]["value"]);
    }
    if (isset($_POST["order"]))
     {
      $this->db->order_by($_POST['order']['0']['column'],$_POST['order']['0']['dir']);
    }
    else 
    {
      $this->db->order_by("p_id","desc");
    }
  }
  function make_datatables()
  {
    $this->make_query();
    if ($_POST["length"] != -1) {
      $this->db->limit($_POST["length"],$_POST["start"]);
    }
    $query = $this->db->get();
    return $query->result();
  }
  function get_filtered_data()
  {
    $this->make_query();
    $query = $this->db->get();
    return $query->num_rows();
  }
  function get_all_data()
  {
    $restaurant    = $this->session->userdata['restaurant'];
    $restaurant_id = $restaurant['restaurant_id'];

    $this->db->select("*");
    $this->db->from("products");
    $this->db->where('r_id',$restaurant_id);
    return $this->db->count_all_results();
  }
  
  public function getChoiceProducts($id)
  {
    $this->db->select('product_choice_categories.product_id,products.p_id,products.name');
    $this->db->from('product_choice_categories');
    $this->db->join('products','products.p_id=product_choice_categories.product_id');
    $this->db->where('products.r_id',$id);
    $this->db->group_by('product_choice_categories.product_id');
    return $this->db->get()->result();
  }

  public function getImage($id)
  {
    $this->db->select('image');
    $this->db->from('product_images');
    $this->db->where('p_id',$id);
    $this->db->limit('1');
    return $this->db->get()->row()->image;
  }

  public function getProducts($id,$param)
  {
    $this->db->select('*');
    $this->db->from('products');
    $this->db->where('r_id',$id);
    if($param=='a') {
        $this->db->order_by('name','asc');
    } elseif($param=='d') {
        $this->db->order_by('name','desc');
    } else {
        $this->db->order_by('p_id','desc');
    }   
    $this->db->where('status!=','deleted');
    return $this->db->get()->result();
  }
  public function getProductDays($day_id,$id)
  {
    $this->db->select('*');
    $this->db->from('product_days');
    $this->db->where('p_id',$id);
    $this->db->where('day_id',$day_id);
    return $this->db->get()->num_rows();
  }
  public function getRestaurantExtras($id)
  {
    $this->db->select('*');
    $this->db->from('extras');
    $this->db->where('r_id',$id);
    $this->db->where('status','1');
    $this->db->order_by('extra_id','desc');
    return $this->db->get()->result();
  }
  public function getProductExtras($id,$product)
  {
    $this->db->select('*');
    $this->db->from('products');
    $this->db->where('r_id',$id);
    $this->db->group_start();
    $this->db->where('type','e');
    $this->db->or_where('type','a');
    $this->db->group_end();
    $this->db->where('status','active');
    $this->db->where('p_id!=',$product);
    return $this->db->get()->result();
  }
}

?>
