<?php

class M_orders extends CI_Model
{
  function __construct()
  {
    $this->load->database();
  }
  function getNewOrders($rest_id)
  {
        $this->db->select('*');
        $this->db->from('orders');
        $this->db->where('status','pending');
        $this->db->where('order_type!=','scheduled');
        $this->db->where('r_id',$rest_id);
        $this->db->where('branch_id','0');
        $this->db->order_by('order_id','desc');
        $result=$this->db->get();
        return $result->result();
   }
   
   function getScheduledOrders($rest_id)
   {
        $this->db->select('*');
        $this->db->from('orders');
        $this->db->where('status','pending');
        $this->db->where('order_type','scheduled');
        $this->db->where('r_id',$rest_id);
        $this->db->where('branch_id','0');
        $this->db->order_by('order_id','desc');
        $result=$this->db->get();
        return $result->result();
   }
  
   function getApprovedOrders($rest_id)
   {
        $this->db->select('*');
        $this->db->from('orders');
        $this->db->where('status','approved');
        $this->db->where('r_id',$rest_id);
        $this->db->order_by('order_id','desc');
        $result=$this->db->get();
        return $result->result();
   }
   
   function getActiveOrders($rest_id)
   {
        $this->db->select('*');
        $this->db->from('orders');
        $this->db->where('status','processing');
        $this->db->where('r_id',$rest_id);
        $this->db->where('branch_id','0');
        $this->db->order_by('order_id','desc');
        $result=$this->db->get();
        return $result->result();
   }

   function getDispatchedOrders($rest_id)
   {
        $this->db->select('*');
        $this->db->from('orders');
        $this->db->where('status','dispatched');
        $this->db->where('r_id',$rest_id);
        $this->db->where('branch_id','0');
        $this->db->order_by('order_id','desc');
        $result=$this->db->get();
        return $result->result();
   }
  

   function getCompletedOrders($rest_id)
   {
        $this->db->select('*');
        $this->db->from('orders');
        $this->db->where('status','delivered');
        $this->db->where('r_id',$rest_id);
        $this->db->where('branch_id','0');
        $this->db->order_by('order_id','desc');
        $result=$this->db->get();
        return $result->result();
   }

   function getCancelledOrders($rest_id)
   {
        $this->db->select('*');
        $this->db->from('orders');
        $this->db->where('status','cancelled');
        $this->db->where('r_id',$rest_id);
        // $this->db->where('branch_id','0');
        $this->db->order_by('order_id','desc');
        $result=$this->db->get();
        return $result->result();
   }
  
  
    function getDrivers($latitude,$longitude,$date,$time)
    {
        $query = "SELECT driver_id,date,time,SQRT(POW(69.1 * (latitude - $latitude), 2) +POW(69.1 * (longitude - $longitude) * COS(latitude / 57.3), 2)) AS distance FROM locations WHERE location_id IN (SELECT MAX(location_id) FROM locations GROUP BY driver_id) HAVING distance<10 AND date='$date' ORDER BY distance;";
        $res = $this->db->query($query);
        return $res->result();
    } 
    
//******************************************* NEW *****************************************************************************************************************//
    function make_new_query()
    {
        $restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        
        $table = "orders";
        $select_column = array("order_id","r_id","branch_id","user_id","total","ordered_date","ordered_time","status","offer_code","delivery_notes","completed_date","completed_time","type");
        $order_column = array("order_id",null,null,null,null,null,null,null,null,null,null,null);
    
        $this->db->select($select_column);
        $this->db->from($table);
        $this->db->where('status','pending');
        $this->db->where('order_type!=','scheduled');
        $this->db->where('r_id',$restaurant_id);
        if (isset($_POST["search"]["value"])) {
          $this->db->like("order_id",$_POST["search"]["value"],'after');
        }
        if (isset($_POST["order"])) {
          $this->db->order_by($_POST['order']['0']['column'],$_POST['order']['0']['dir']);
        }
        else {
          $this->db->order_by("order_id","desc");
        }
    }
    function make_new_datatables()
    {
        $this->make_new_query();
        if ($_POST["length"] != -1) {
          $this->db->limit($_POST["length"],$_POST["start"]);
        }
        $query = $this->db->get();
        return $query->result();
    }
    function get_new_filtered_data()
    {
        $this->make_new_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    function get_new_all_data()
    {
        $restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        
        $this->db->select("*");
        $this->db->from("orders");
        $this->db->where('status','pending');
        $this->db->where('order_type!=','scheduled');
        $this->db->where('r_id',$restaurant_id);
        return $this->db->count_all_results();
    }   
    
//********************************************************** SCHEDULED *********************************************************************************************//
    function make_scheduled_query()
    {
        $restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        
        $table = "orders";
        $select_column = array("order_id","r_id","branch_id","user_id","total","ordered_date","ordered_time","status","offer_code","delivery_notes","completed_date","completed_time","type");
        $order_column = array("order_id",null,null,null,null,null,null,null,null,null,null,null);
    
        $this->db->select($select_column);
        $this->db->from($table);
        $this->db->where('status','pending');
        $this->db->where('order_type','scheduled');
        $this->db->where('r_id',$restaurant_id);
        if (isset($_POST["search"]["value"])) {
          $this->db->like("order_id",$_POST["search"]["value"]);
        }
        if (isset($_POST["order"])) {
          $this->db->order_by($_POST['order']['0']['column'],$_POST['order']['0']['dir']);
        }
        else {
          $this->db->order_by("order_id","desc");
        }
    }
    function make_scheduled_datatables()
    {
        $this->make_scheduled_query();
        if ($_POST["length"] != -1) {
          $this->db->limit($_POST["length"],$_POST["start"]);
        }
        $query = $this->db->get();
        return $query->result();
    }
    function get_scheduled_filtered_data()
    {
        $this->make_scheduled_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    function get_scheduled_all_data()
    {
        $restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        
        $this->db->select("*");
        $this->db->from("orders");
        $this->db->where('status','pending');
        $this->db->where('order_type','scheduled');
        $this->db->where('r_id',$restaurant_id);
        return $this->db->count_all_results();
    }
    
//********************************************************* APPROVED ************************************************************************************************//
    function make_approved_query()
    {
        $restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        
        $table = "orders";
        $select_column = array("order_id","r_id","branch_id","user_id","total","ordered_date","ordered_time","status","offer_code","delivery_notes","completed_date","completed_time","type");
        $order_column = array("order_id",null,null,null,null,null,null,null,null,null,null,null);
    
        $this->db->select($select_column);
        $this->db->from($table);
        $this->db->where('status','approved');
        $this->db->where('r_id',$restaurant_id);
        if (isset($_POST["search"]["value"])) {
          $this->db->like("order_id",$_POST["search"]["value"]);
        }
        if (isset($_POST["order"])) {
          $this->db->order_by($_POST['order']['0']['column'],$_POST['order']['0']['dir']);
        }
        else {
          $this->db->order_by("order_id","desc");
        }
    }
    function make_approved_datatables()
    {
        $this->make_approved_query();
        if ($_POST["length"] != -1) {
          $this->db->limit($_POST["length"],$_POST["start"]);
        }
        $query = $this->db->get();
        return $query->result();
    }
    function get_approved_filtered_data()
    {
        $this->make_approved_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    function get_approved_all_data()
    {
        $restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        
        $this->db->select("*");
        $this->db->from("orders");
        $this->db->where('status','approved');
        $this->db->where('r_id',$restaurant_id);
        return $this->db->count_all_results();
    }
    
//********************************************************* ACTIVE **************************************************************************************************//
   function make_active_query()
    {
        $restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        
        $table = "orders";
        $select_column = array("order_id","r_id","branch_id","user_id","total","ordered_date","ordered_time","status","offer_code","delivery_notes","completed_date","completed_time","type");
        $order_column = array("order_id",null,null,null,null,null,null,null,null,null,null,null);
    
        $this->db->select($select_column);
        $this->db->from($table);
        $this->db->where('status','processing');
        $this->db->where('r_id',$restaurant_id);
        if (isset($_POST["search"]["value"])) {
          $this->db->like("order_id",$_POST["search"]["value"]);
        }
        if (isset($_POST["order"])) {
          $this->db->order_by($_POST['order']['0']['column'],$_POST['order']['0']['dir']);
        }
        else {
          $this->db->order_by("order_id","desc");
        }
    }
    function make_active_datatables()
    {
        $this->make_active_query();
        if ($_POST["length"] != -1) {
          $this->db->limit($_POST["length"],$_POST["start"]);
        }
        $query = $this->db->get();
        return $query->result();
    }
    function get_active_filtered_data()
    {
        $this->make_active_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    function get_active_all_data()
    {
        $restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        
        $this->db->select("*");
        $this->db->from("orders");
        $this->db->where('status','processing');
        $this->db->where('r_id',$restaurant_id);
        return $this->db->count_all_results();
    }
    
//*************************************************************** COMPLETED ******************************************************************************************//
   function make_completed_query()
    {
        $restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        
        $table = "orders";
        $select_column = array("order_id","r_id","branch_id","user_id","total","ordered_date","ordered_time","status","offer_code","delivery_notes","completed_date","completed_time","type");
        $order_column = array("order_id",null,null,null,null,null,null,null,null,null,null,null);
    
        $this->db->select($select_column);
        $this->db->from($table);
        $this->db->where('status','delivered');
        $this->db->where('r_id',$restaurant_id);
        if (isset($_POST["search"]["value"])) {
          $this->db->like("order_id",$_POST["search"]["value"]);
        }
        if (isset($_POST["order"])) {
          $this->db->order_by($_POST['order']['0']['column'],$_POST['order']['0']['dir']);
        }
        else {
          $this->db->order_by("order_id","desc");
        }
    }
    function make_completed_datatables()
    {
        $this->make_completed_query();
        if ($_POST["length"] != -1) {
          $this->db->limit($_POST["length"],$_POST["start"]);
        }
        $query = $this->db->get();
        return $query->result();
    }
    function get_completed_filtered_data()
    {
        $this->make_completed_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    function get_completed_all_data()
    {
        $restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        
        $this->db->select("*");
        $this->db->from("orders");
        $this->db->where('status','delivered');
        $this->db->where('r_id',$restaurant_id);
        return $this->db->count_all_results();
    }
    
//******************************************************** DISPATCHED *****************************************************************************************************//
   function make_dispatched_query()
    {
        $restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        
        $table = "orders";
        $select_column = array("order_id","r_id","branch_id","user_id","total","ordered_date","ordered_time","status","offer_code","delivery_notes","completed_date","completed_time","type");
        $order_column = array("order_id",null,null,null,null,null,null,null,null,null,null,null);
    
        $this->db->select($select_column);
        $this->db->from($table);
        $this->db->where('status','dispatched');
        $this->db->where('r_id',$restaurant_id);
        if (isset($_POST["search"]["value"])) {
          $this->db->like("order_id",$_POST["search"]["value"]);
        }
        if (isset($_POST["order"])) {
          $this->db->order_by($_POST['order']['0']['column'],$_POST['order']['0']['dir']);
        }
        else {
          $this->db->order_by("order_id","desc");
        }
    }
    function make_dispatched_datatables()
    {
        $this->make_dispatched_query();
        if ($_POST["length"] != -1) {
          $this->db->limit($_POST["length"],$_POST["start"]);
        }
        $query = $this->db->get();
        return $query->result();
    }
    function get_dispatched_filtered_data()
    {
        $this->make_dispatched_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    function get_dispatched_all_data()
    {
        $restaurant    = $this->session->userdata['restaurant'];
        $restaurant_id = $restaurant['restaurant_id'];
        
        $this->db->select("*");
        $this->db->from("orders");
        $this->db->where('status','dispatched');
        $this->db->where('r_id',$restaurant_id);
        return $this->db->count_all_results();
    }
}

?>
